/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import eu.dnetlib.pace.clustering.AbstractClusteringFunction;
import eu.dnetlib.pace.clustering.ClusteringClass;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@ClusteringClass(value="keywordsclustering")
public class KeywordsClustering
extends AbstractClusteringFunction {
    public KeywordsClustering(Map<String, Integer> params) {
        super(params);
    }

    @Override
    protected Collection<String> doApply(Config conf, String s) {
        Set<String> keywords = this.getKeywords(s, conf.translationMap(), this.params.getOrDefault("windowSize", 4));
        Set<String> cities = this.getCities(s, this.params.getOrDefault("windowSize", 4));
        LinkedHashSet<String> combinations = new LinkedHashSet<String>();
        for (String keyword : this.keywordsToCodes(keywords, conf.translationMap())) {
            for (String city : this.citiesToCodes(cities)) {
                combinations.add(keyword + "-" + city);
                if (combinations.size() < this.params.getOrDefault("max", 2)) continue;
                return combinations;
            }
        }
        return combinations;
    }

    @Override
    public Collection<String> apply(Config conf, List<Field> fields) {
        return fields.stream().filter(f -> !f.isEmpty()).map(Field::stringValue).map(this::cleanup).map(this::normalize).map(s -> this.filterAllStopWords((String)s)).map(s -> this.doApply(conf, (String)s)).map(c -> this.filterBlacklisted((Collection<String>)c, ngramBlacklist)).flatMap(c -> c.stream()).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(HashSet::new));
    }
}

