/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.condition;

import com.google.common.collect.Sets;
import eu.dnetlib.pace.condition.AbstractCondition;
import eu.dnetlib.pace.condition.ConditionClass;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.distance.eval.ConditionEval;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import eu.dnetlib.pace.model.FieldList;
import eu.dnetlib.pace.model.adaptor.Pid;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ConditionClass(value="pidMatch")
public class PidMatch
extends AbstractCondition {
    private static final Log log = LogFactory.getLog(PidMatch.class);

    public PidMatch(String cond, List<FieldDef> fields) {
        super(cond, fields);
    }

    @Override
    protected ConditionEval verify(FieldDef fd, Field a, Field b, Config conf) {
        int simDiff;
        Set<String> pidBset;
        List<String> sa = ((FieldList)a).stringList();
        List<String> sb = ((FieldList)b).stringList();
        List<Pid> pal = Pid.fromOafJson(sa);
        List<Pid> pbl = Pid.fromOafJson(sb);
        Set<String> pidAset = this.toHashSet(pal);
        int incommon = Sets.intersection(pidAset, pidBset = this.toHashSet(pbl)).size();
        if (incommon + (simDiff = Sets.symmetricDifference(pidAset, pidBset).size()) == 0) {
            return new ConditionEval(this.cond, a, b, 0);
        }
        int result = (double)(incommon / (incommon + simDiff)) > 0.5 ? 1 : -1;
        return new ConditionEval(this.cond, a, b, result);
    }

    private Set<String> toHashSet(List<Pid> pbl) {
        return pbl.stream().map(pid -> pid.getType() + this.normalizePid(pid.getValue())).collect(Collectors.toCollection(HashSet::new));
    }
}

