/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance;

import eu.dnetlib.pace.condition.ConditionAlgo;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.distance.eval.ConditionEvalMap;
import eu.dnetlib.pace.distance.eval.DistanceEval;
import eu.dnetlib.pace.distance.eval.DistanceEvalMap;
import eu.dnetlib.pace.distance.eval.ScoreResult;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.FieldValueImpl;
import eu.dnetlib.pace.util.PaceException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DistanceScorer {
    private static final Log log = LogFactory.getLog(DistanceScorer.class);
    private Config config;

    public DistanceScorer(Config config) {
        this.config = config;
    }

    public ScoreResult distance(Document a, Document b) {
        ScoreResult sr = new ScoreResult();
        sr.setStrictConditions(this.verify(a, b, this.config.strictConditions()));
        sr.setConditions(this.verify(a, b, this.config.conditions()));
        DistanceEvalMap dMap = new DistanceEvalMap(this.sumWeights(this.config.model()));
        for (FieldDef fd : this.config.model()) {
            dMap.updateDistance(this.fieldDistance(a, b, fd));
        }
        sr.setDistances(dMap);
        return sr;
    }

    private ConditionEvalMap verify(Document a, Document b, List<ConditionAlgo> conditions) {
        ConditionEvalMap res = new ConditionEvalMap();
        for (ConditionAlgo cd : conditions) {
            ConditionEvalMap map = cd.verify(a, b, this.config);
            res.mergeFrom(map);
        }
        return res;
    }

    private DistanceEval fieldDistance(Document a, Document b, FieldDef fd) {
        double w = fd.getWeight();
        Field va = this.getValue(a, fd);
        Field vb = this.getValue(b, fd);
        DistanceEval de = new DistanceEval(fd, va, vb);
        if (w == 0.0) {
            return de;
        }
        if (va.isEmpty() || vb.isEmpty()) {
            if (fd.isIgnoreMissing()) {
                de.setDistance(-1.0);
            } else {
                de.setDistance(w);
            }
        } else if (va.getType().equals((Object)vb.getType())) {
            de.setDistance(w * fd.distanceAlgo().distance(va, vb, this.config));
        } else {
            throw new PaceException(String.format("Types are different: %s:%s - %s:%s", new Object[]{va, va.getType(), vb, vb.getType()}));
        }
        return de;
    }

    private Field getValue(Document d, FieldDef fd) {
        Field v = d.values(fd.getName());
        if (fd.getLength() > 0) {
            if (v instanceof FieldValueImpl) {
                ((FieldValueImpl)v).setValue(StringUtils.substring((String)v.stringValue(), (int)0, (int)fd.getLength()));
            } else if (v instanceof FieldListImpl) {
                List<String> strings = ((FieldListImpl)v).stringList();
                strings = strings.stream().limit(fd.getSize() > 0 ? (long)fd.getSize() : (long)strings.size()).map(s -> StringUtils.substring((String)s, (int)0, (int)fd.getLength())).collect(Collectors.toList());
                ((FieldListImpl)v).clear();
                ((FieldListImpl)v).addAll(strings.stream().limit(fd.getSize() > 0 ? (long)fd.getSize() : (long)strings.size()).map(s -> StringUtils.substring((String)s, (int)0, (int)fd.getLength())).map(s -> new FieldValueImpl(v.getType(), v.getName(), s)).collect(Collectors.toList()));
            }
        }
        return v;
    }

    private double sumWeights(Collection<FieldDef> fields) {
        double sum = 0.0;
        for (FieldDef fd : fields) {
            sum += fd.getWeight();
        }
        return sum;
    }
}

