/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance.algo;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.Levenstein;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.distance.DistanceClass;
import eu.dnetlib.pace.distance.SecondStringDistanceAlgo;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@DistanceClass(value="LevensteinTitle")
public class LevensteinTitle
extends SecondStringDistanceAlgo {
    private static final Log log = LogFactory.getLog(LevensteinTitle.class);

    public LevensteinTitle(Map<String, Number> params) {
        super(params, (AbstractStringDistance)new Levenstein());
    }

    public LevensteinTitle(double w) {
        super(w, (AbstractStringDistance)new Levenstein());
    }

    protected LevensteinTitle(double w, AbstractStringDistance ssalgo) {
        super(w, ssalgo);
    }

    @Override
    public double distance(String a, String b, Config conf) {
        String cb;
        String ca = this.cleanup(a);
        boolean check = this.checkNumbers(ca, cb = this.cleanup(b));
        if (check) {
            return 0.5;
        }
        String cca = this.finalCleanup(ca);
        String ccb = this.finalCleanup(cb);
        return this.normalize(this.ssalgo.score(cca, ccb), cca.length(), ccb.length());
    }

    private double normalize(double score, int la, int lb) {
        return 1.0 - Math.abs(score) / (double)Math.max(la, lb);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    protected double normalize(double d) {
        return 1.0 / Math.pow(Math.abs(d) + 1.0, 0.1);
    }
}

