/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.pace.config.PaceConfig;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.distance.DistanceAlgo;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.FieldValueImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldDef
implements Serializable {
    public static final String PATH_SEPARATOR = "/";
    private String algo;
    private String name;
    private String path;
    private boolean ignoreMissing;
    private Type type;
    private boolean overrideMatch;
    private double weight;
    private int size = -1;
    private int length = -1;
    private Map<String, Number> params;

    public Field apply(Type type, String s) {
        switch (type) {
            case Int: {
                return new FieldValueImpl(type, this.name, Integer.parseInt(s));
            }
            case String: {
                return new FieldValueImpl(type, this.name, s);
            }
            case List: {
                return new FieldListImpl(this.name, type);
            }
        }
        throw new IllegalArgumentException("Casting not implemented for type " + (Object)((Object)type));
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getPathList() {
        return Lists.newArrayList((Iterable)Splitter.on((String)PATH_SEPARATOR).split((CharSequence)this.getPath()));
    }

    public DistanceAlgo distanceAlgo() {
        if (this.params == null) {
            this.params = new HashMap<String, Number>();
        }
        this.params.put("weight", this.getWeight());
        return PaceConfig.resolver.getDistanceAlgo(this.getAlgo(), this.params);
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isOverrideMatch() {
        return this.overrideMatch;
    }

    public void setOverrideMatch(boolean overrideMatch) {
        this.overrideMatch = overrideMatch;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String getAlgo() {
        return this.algo;
    }

    public void setAlgo(String algo) {
        this.algo = algo;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Map<String, Number> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Number> params) {
        this.params = params;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setIgnoreMissing(boolean ignoreMissing) {
        this.ignoreMissing = ignoreMissing;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

