/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.AbstractField;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.lang.StringUtils;

public class FieldValueImpl
extends AbstractField
implements FieldValue {
    private Object value = null;

    public FieldValueImpl() {
    }

    public FieldValueImpl(Type type, String name, Object value) {
        super(type, name);
        this.value = value;
    }

    @Override
    public boolean isEmpty() {
        if (this.value == null) {
            return false;
        }
        switch (this.type) {
            case String: 
            case JSON: {
                return this.value.toString().isEmpty();
            }
            case List: {
                List list = (List)this.value;
                return list.isEmpty() || ((FieldValueImpl)list.get(0)).isEmpty();
            }
            case URL: {
                String str = this.value.toString();
                return StringUtils.isBlank((String)str) || !this.isValidURL(str);
            }
        }
        return true;
    }

    private boolean isValidURL(String s) {
        try {
            new URL(s);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public String stringValue() {
        return String.valueOf(this.getValue());
    }

    @Override
    public Iterator<Field> iterator() {
        return new SingletonIterator((Object)this);
    }
}

