/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model.gt;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.dnetlib.pace.model.gt.Author;
import eu.dnetlib.pace.model.gt.Authors;
import eu.dnetlib.pace.model.gt.CoAuthor;
import eu.dnetlib.pace.model.gt.CoAuthors;
import eu.dnetlib.pace.model.gt.GTAuthor;
import java.lang.reflect.Type;

public class GTAuthorOafSerialiser
implements JsonDeserializer<GTAuthor> {
    private static final String VALUE = "value";
    private static final String SECONDNAMES = "secondnames";
    private static final String FIRSTNAME = "firstname";
    private static final String FULLNAME = "fullname";
    private static final String ID = "id";
    private static final String MERGEDPERSON = "mergedperson";
    private static final String METADATA = "metadata";
    private static final String ANCHOR_ID = "anchorId";
    private static final String COAUTHOR = "coauthor";

    public GTAuthor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        GTAuthor gta = new GTAuthor();
        gta.setAuthor(this.getAuthor(json));
        gta.setMerged(this.getMerged(json));
        gta.setCoAuthors(this.getCoAuthors(json));
        return gta;
    }

    private CoAuthors getCoAuthors(JsonElement json) {
        JsonObject obj = json.getAsJsonObject();
        if (!obj.has(COAUTHOR)) {
            return null;
        }
        return new CoAuthors(Lists.newArrayList((Iterable)Iterables.transform((Iterable)obj.get(COAUTHOR).getAsJsonArray(), (Function)new Function<JsonElement, CoAuthor>(){

            public CoAuthor apply(JsonElement in) {
                CoAuthor a = new CoAuthor(GTAuthorOafSerialiser.this.getAuthor(in));
                JsonObject jsonObject = in.getAsJsonObject();
                if (jsonObject.has(GTAuthorOafSerialiser.ANCHOR_ID)) {
                    a.setAnchorId(jsonObject.get(GTAuthorOafSerialiser.ANCHOR_ID).getAsString());
                }
                return a;
            }
        })));
    }

    private Author getAuthor(JsonElement json) {
        Author a = new Author();
        a.setCoauthors(null);
        a.setMatches(null);
        JsonObject jso = json.getAsJsonObject();
        a.setId(jso.has(ID) ? jso.get(ID).getAsString() : null);
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has(METADATA)) {
            JsonObject m = jsonObject.get(METADATA).getAsJsonObject();
            a.setFullname(this.getValue(m, FULLNAME));
            a.setFirstname(this.getValue(m, FIRSTNAME));
            a.setSecondnames(this.getValues(m, SECONDNAMES));
        }
        return a;
    }

    private Authors getMerged(JsonElement json) {
        JsonObject obj = json.getAsJsonObject();
        if (!obj.has(MERGEDPERSON)) {
            return null;
        }
        return new Authors(Lists.newArrayList((Iterable)Iterables.transform((Iterable)obj.get(MERGEDPERSON).getAsJsonArray(), (Function)new Function<JsonElement, Author>(){

            public Author apply(JsonElement in) {
                return GTAuthorOafSerialiser.this.getAuthor(in);
            }
        })));
    }

    private String getValues(JsonObject m, String fieldName) {
        return m.has(fieldName) ? Joiner.on((String)" ").join(Iterables.transform((Iterable)m.get(fieldName).getAsJsonArray(), (Function)new Function<JsonElement, String>(){

            public String apply(JsonElement in) {
                return in.getAsJsonObject().get(GTAuthorOafSerialiser.VALUE).getAsString();
            }
        })) : null;
    }

    private String getValue(JsonObject m, String fieldName) {
        return m.has(fieldName) ? m.get(fieldName).getAsJsonObject().get(VALUE).getAsString() : null;
    }
}

