/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance.algo;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.JaroWinkler;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.distance.DistanceClass;
import eu.dnetlib.pace.distance.SecondStringDistanceAlgo;
import java.util.Map;
import java.util.Set;

@DistanceClass(value="JaroWinklerNormalizedName")
public class JaroWinklerNormalizedName
extends SecondStringDistanceAlgo {
    private Map<String, Number> params;

    public JaroWinklerNormalizedName(Map<String, Number> params) {
        super(params, (AbstractStringDistance)new JaroWinkler());
        this.params = params;
    }

    public JaroWinklerNormalizedName(double weight) {
        super(weight, (AbstractStringDistance)new JaroWinkler());
    }

    protected JaroWinklerNormalizedName(double weight, AbstractStringDistance ssalgo) {
        super(weight, ssalgo);
    }

    @Override
    public double distance(String a, String b, Config conf) {
        Set<String> cities2;
        String ca = this.cleanup(a);
        String cb = this.cleanup(b);
        ca = this.normalize(ca);
        cb = this.normalize(cb);
        ca = this.filterAllStopWords(ca);
        cb = this.filterAllStopWords(cb);
        Set<String> keywords1 = this.getKeywords(ca, conf.translationMap(), this.params.getOrDefault("windowSize", 4).intValue());
        Set<String> keywords2 = this.getKeywords(cb, conf.translationMap(), this.params.getOrDefault("windowSize", 4).intValue());
        Set<String> cities1 = this.getCities(ca, this.params.getOrDefault("windowSize", 4).intValue());
        if (this.sameCity(cities1, cities2 = this.getCities(cb, this.params.getOrDefault("windowSize", 4).intValue())) && this.keywordsCompare(keywords1, keywords2, conf.translationMap()) > this.params.getOrDefault("threshold", 0.5).doubleValue()) {
            ca = this.removeKeywords(ca, keywords1);
            ca = this.removeKeywords(ca, cities1);
            cb = this.removeKeywords(cb, keywords2);
            cb = this.removeKeywords(cb, cities2);
            if (ca.isEmpty() && cb.isEmpty()) {
                return 1.0;
            }
            return this.normalize(this.ssalgo.score(ca, cb));
        }
        return 0.0;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    protected double normalize(double d) {
        return d;
    }
}

