/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance.algo;

import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.distance.DistanceClass;
import eu.dnetlib.pace.distance.algo.Levenstein;
import eu.dnetlib.pace.model.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@DistanceClass(value="urlMatcher")
public class UrlMatcher
extends Levenstein {
    private Map<String, Number> params;

    public UrlMatcher(Map<String, Number> params) {
        super(params);
        this.params = params;
    }

    public UrlMatcher(double weight, Map<String, Number> params) {
        super(weight);
        this.params = params;
    }

    public void setParams(Map<String, Number> params) {
        this.params = params;
    }

    @Override
    public double distance(Field a, Field b, Config conf) {
        URL urlA = this.asUrl(this.getFirstValue(a));
        URL urlB = this.asUrl(this.getFirstValue(b));
        if (!urlA.getHost().equalsIgnoreCase(urlB.getHost())) {
            return 0.0;
        }
        Double hostW = this.params.get("host").doubleValue();
        Double pathW = this.params.get("path").doubleValue();
        if (StringUtils.isBlank((String)urlA.getPath()) || StringUtils.isBlank((String)urlB.getPath())) {
            return hostW * 0.5;
        }
        return hostW + pathW * super.distance(urlA.getPath(), urlB.getPath(), conf);
    }

    private URL asUrl(String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("invalid URL: " + value);
        }
    }
}

