/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.util.Map;

@ComparatorClass(value="containsMatch")
public class ContainsMatch
extends AbstractComparator {
    private Map<String, String> params;

    public ContainsMatch(Map<String, String> params) {
        super(params);
        this.params = params;
    }

    @Override
    public double distance(String a, String b, Config conf) {
        boolean caseSensitive = Boolean.parseBoolean(this.params.getOrDefault("caseSensitive", "false"));
        String string = this.params.get("string");
        String agg = this.params.get("bool");
        String ca = a;
        String cb = b;
        if (!caseSensitive) {
            ca = a.toLowerCase();
            cb = b.toLowerCase();
        }
        switch (agg) {
            case "AND": {
                if (!ca.contains(string) || !cb.contains(string)) break;
                return 1.0;
            }
            case "OR": {
                if (!ca.contains(string) && !cb.contains(string)) break;
                return 1.0;
            }
            case "XOR": {
                if (!(ca.contains(string) ^ cb.contains(string))) break;
                return 1.0;
            }
            default: {
                return 0.0;
            }
        }
        return 0.0;
    }
}

