/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.tree.Levenstein;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@ComparatorClass(value="urlMatcher")
public class UrlMatcher
extends Levenstein {
    private Map<String, String> params;

    public UrlMatcher(Map<String, String> params) {
        super(params);
        this.params = params;
    }

    public UrlMatcher(double weight, Map<String, String> params) {
        super(weight);
        this.params = params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    @Override
    public double distance(Field a, Field b, Config conf) {
        URL urlA = this.asUrl(this.getFirstValue(a));
        URL urlB = this.asUrl(this.getFirstValue(b));
        if (!urlA.getHost().equalsIgnoreCase(urlB.getHost())) {
            return 0.0;
        }
        Double hostW = Double.parseDouble(this.params.getOrDefault("host", "0.5"));
        Double pathW = Double.parseDouble(this.params.getOrDefault("path", "0.5"));
        if (StringUtils.isBlank((CharSequence)urlA.getPath()) || StringUtils.isBlank((CharSequence)urlB.getPath())) {
            return hostW * 0.5;
        }
        return hostW + pathW * super.distance(urlA.getPath(), urlB.getPath(), conf);
    }

    private URL asUrl(String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("invalid URL: " + value);
        }
    }
}

