/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree.support;

import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.tree.support.MatchType;
import eu.dnetlib.pace.tree.support.TreeNodeDef;
import eu.dnetlib.pace.tree.support.TreeNodeStats;
import eu.dnetlib.pace.tree.support.TreeStats;
import eu.dnetlib.pace.util.PaceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeProcessor {
    private static final Log log = LogFactory.getLog(TreeProcessor.class);
    private Config config;

    public TreeProcessor(Config config) {
        this.config = config;
    }

    public boolean compare(MapDocument a, MapDocument b) {
        return this.evaluateTree(a, b).getResult() == MatchType.MATCH;
    }

    public TreeStats evaluateTree(MapDocument doc1, MapDocument doc2) {
        TreeStats treeStats = new TreeStats();
        String current = "start";
        while (MatchType.parse(current) == MatchType.UNDEFINED) {
            TreeNodeDef currentNode = this.config.decisionTree().get(current);
            if (currentNode == null) {
                throw new PaceException("Missing tree node: " + current);
            }
            TreeNodeStats stats = currentNode.evaluate(doc1, doc2, this.config);
            treeStats.addNodeStats(current, stats);
            if (!currentNode.isIgnoreUndefined() && stats.undefinedCount() > 0) {
                current = currentNode.getUndefined();
                continue;
            }
            if (stats.getFinalScore(currentNode.getAggregation()) >= currentNode.getThreshold()) {
                current = currentNode.getPositive();
                continue;
            }
            current = currentNode.getNegative();
        }
        treeStats.setResult(MatchType.parse(current));
        return treeStats;
    }

    public double computeScore(MapDocument doc1, MapDocument doc2) {
        String current = "start";
        double score = 0.0;
        while (MatchType.parse(current) == MatchType.UNDEFINED) {
            TreeNodeDef currentNode = this.config.decisionTree().get(current);
            if (currentNode == null) {
                throw new PaceException("The Tree Node doesn't exist: " + current);
            }
            TreeNodeStats stats = currentNode.evaluate(doc1, doc2, this.config);
            score = stats.getFinalScore(currentNode.getAggregation());
            if (!currentNode.isIgnoreUndefined() && stats.undefinedCount() > 0) {
                current = currentNode.getUndefined();
                continue;
            }
            if (stats.getFinalScore(currentNode.getAggregation()) >= currentNode.getThreshold()) {
                current = currentNode.getPositive();
                continue;
            }
            current = currentNode.getNegative();
        }
        return score;
    }
}

