/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldList;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ComparatorClass(value="listContainsMatch")
public class ListContainsMatch
extends AbstractComparator {
    private Map<String, String> params;
    private boolean CASE_SENSITIVE;
    private String STRING;
    private String AGGREGATOR;

    public ListContainsMatch(Map<String, String> params) {
        super(params);
        this.params = params;
        this.CASE_SENSITIVE = Boolean.parseBoolean(params.getOrDefault("caseSensitive", "false"));
        this.STRING = params.get("string");
        this.AGGREGATOR = params.get("bool");
    }

    @Override
    public double compare(Field a, Field b, Config conf) {
        List<String> sa = ((FieldList)a).stringList();
        List<String> sb = ((FieldList)b).stringList();
        if (sa.isEmpty() || sb.isEmpty()) {
            return -1.0;
        }
        if (!this.CASE_SENSITIVE) {
            sa = sa.stream().map(String::toLowerCase).collect(Collectors.toList());
            sb = sb.stream().map(String::toLowerCase).collect(Collectors.toList());
            this.STRING = this.STRING.toLowerCase();
        }
        switch (this.AGGREGATOR) {
            case "AND": {
                if (!sa.contains(this.STRING) || !sb.contains(this.STRING)) break;
                return 1.0;
            }
            case "OR": {
                if (!sa.contains(this.STRING) && !sb.contains(this.STRING)) break;
                return 1.0;
            }
            case "XOR": {
                if (!(sa.contains(this.STRING) ^ sb.contains(this.STRING))) break;
                return 1.0;
            }
            default: {
                return 0.0;
            }
        }
        return 0.0;
    }
}

