/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.util.Map;

@ComparatorClass(value="stringContainsMatch")
public class StringContainsMatch
extends AbstractComparator {
    private Map<String, String> params;
    private boolean CASE_SENSITIVE;
    private String STRING;
    private String AGGREGATOR;

    public StringContainsMatch(Map<String, String> params) {
        super(params);
        this.params = params;
        this.CASE_SENSITIVE = Boolean.parseBoolean(params.getOrDefault("caseSensitive", "false"));
        this.STRING = params.get("string");
        this.AGGREGATOR = params.get("aggregator");
    }

    @Override
    public double distance(String a, String b, Config conf) {
        String ca = a;
        String cb = b;
        if (!this.CASE_SENSITIVE) {
            ca = a.toLowerCase();
            cb = b.toLowerCase();
            this.STRING = this.STRING.toLowerCase();
        }
        switch (this.AGGREGATOR) {
            case "AND": {
                if (!ca.contains(this.STRING) || !cb.contains(this.STRING)) break;
                return 1.0;
            }
            case "OR": {
                if (!ca.contains(this.STRING) && !cb.contains(this.STRING)) break;
                return 1.0;
            }
            case "XOR": {
                if (!(ca.contains(this.STRING) ^ cb.contains(this.STRING))) break;
                return 1.0;
            }
            default: {
                return 0.0;
            }
        }
        return 0.0;
    }
}

