/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@ComparatorClass(value="yearMatch")
public class YearMatch
extends AbstractComparator {
    private int limit = 4;

    public YearMatch(Map<String, String> params) {
        super(params);
    }

    @Override
    public double compare(Field a, Field b, Config conf) {
        String valueA = this.getNumbers(this.getFirstValue(a));
        String valueB = this.getNumbers(this.getFirstValue(b));
        if (valueA.isEmpty() || valueB.isEmpty()) {
            return -1.0;
        }
        boolean lengthMatch = this.checkLength(valueA) && this.checkLength(valueB);
        boolean onemissing = valueA.isEmpty() || valueB.isEmpty();
        return lengthMatch && valueA.equals(valueB) || onemissing ? 1.0 : 0.0;
    }

    protected boolean checkLength(String s) {
        return s.length() == this.limit;
    }

    @Override
    protected String getFirstValue(Field value) {
        return value != null && !value.isEmpty() ? StringUtils.left((String)value.stringValue(), (int)this.limit) : "";
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + super.toString();
    }
}

