/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import com.google.common.collect.Sets;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldList;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ComparatorClass(value="jsonListMatch")
public class JsonListMatch
extends AbstractComparator {
    private static final Log log = LogFactory.getLog(JsonListMatch.class);
    private Map<String, String> params;
    private String MODE;

    public JsonListMatch(Map<String, String> params) {
        super(params);
        this.params = params;
        this.MODE = params.getOrDefault("mode", "percentage");
    }

    @Override
    public double compare(Field a, Field b, Config conf) {
        int simDiff;
        Set cb;
        List<String> sa = ((FieldList)a).stringList();
        List<String> sb = ((FieldList)b).stringList();
        if (sa.isEmpty() || sb.isEmpty()) {
            return -1.0;
        }
        Set ca = sa.stream().map(this::toComparableString).collect(Collectors.toSet());
        int incommon = Sets.intersection(ca, cb = sb.stream().map(this::toComparableString).collect(Collectors.toSet())).size();
        if (incommon + (simDiff = Sets.symmetricDifference(ca, cb).size()) == 0) {
            return 0.0;
        }
        if (this.MODE.equals("percentage")) {
            return (double)incommon / (double)(incommon + simDiff);
        }
        return incommon;
    }

    private String toComparableString(String json) {
        StringBuilder st = new StringBuilder();
        for (String key : this.params.keySet().stream().filter(k -> k.contains("jpath")).collect(Collectors.toList())) {
            String path = this.params.get(key);
            String value = MapDocumentUtil.getJPathString(path, json);
            if (value == null || value.isEmpty()) {
                value = "";
            }
            st.append(value + "::");
        }
        st.setLength(st.length() - 2);
        return st.toString();
    }
}

