/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.util.Map;
import java.util.Set;

@ComparatorClass(value="keywordMatch")
public class KeywordMatch
extends AbstractComparator {
    Map<String, String> params;

    public KeywordMatch(Map<String, String> params) {
        super(params);
        this.params = params;
    }

    @Override
    public double distance(String a, String b, Config conf) {
        String ca = this.cleanup(a);
        String cb = this.cleanup(b);
        ca = this.normalize(ca);
        cb = this.normalize(cb);
        ca = this.filterAllStopWords(ca);
        cb = this.filterAllStopWords(cb);
        Set<String> keywords1 = this.getKeywords(ca, conf.translationMap(), Integer.parseInt(this.params.getOrDefault("windowSize", "4")));
        Set<String> keywords2 = this.getKeywords(cb, conf.translationMap(), Integer.parseInt(this.params.getOrDefault("windowSize", "4")));
        Set<String> codes1 = this.toCodes(keywords1, conf.translationMap());
        Set<String> codes2 = this.toCodes(keywords2, conf.translationMap());
        if (codes1.isEmpty() && codes2.isEmpty()) {
            return 1.0;
        }
        if (codes1.isEmpty() ^ codes2.isEmpty()) {
            return -1.0;
        }
        return this.commonElementsPercentage(codes1, codes2);
    }
}

