/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import com.google.common.collect.Sets;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldList;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ComparatorClass(value="stringListMatch")
public class StringListMatch
extends AbstractComparator {
    private static final Log log = LogFactory.getLog(StringListMatch.class);
    private Map<String, String> params;
    private final String TYPE;

    public StringListMatch(Map<String, String> params) {
        super(params);
        this.params = params;
        this.TYPE = params.getOrDefault("type", "percentage");
    }

    @Override
    public double compare(Field a, Field b, Config conf) {
        int simDiff;
        HashSet<String> pa = new HashSet<String>(((FieldList)a).stringList());
        HashSet<String> pb = new HashSet<String>(((FieldList)b).stringList());
        if (pa.isEmpty() || pb.isEmpty()) {
            return -1.0;
        }
        int incommon = Sets.intersection(pa, pb).size();
        if (incommon + (simDiff = Sets.symmetricDifference(pa, pb).size()) == 0) {
            return 0.0;
        }
        if (this.TYPE.equals("percentage")) {
            return (double)incommon / (double)(incommon + simDiff);
        }
        return incommon;
    }
}

