/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.collect.Maps;
import eu.dnetlib.pace.clustering.ClusteringCombiner;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.MapDocument;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class BlacklistAwareClusteringCombiner
extends ClusteringCombiner {
    public static Collection<String> filterAndCombine(MapDocument a, Config conf) {
        MapDocument filtered = BlacklistAwareClusteringCombiner.filter(a, conf.blacklists());
        return BlacklistAwareClusteringCombiner.combine(filtered, conf);
    }

    private static MapDocument filter(MapDocument a, Map<String, List<Pattern>> blacklists) {
        if (blacklists == null || blacklists.isEmpty()) {
            return a;
        }
        HashMap filtered = Maps.newHashMap(a.getFieldMap());
        for (Map.Entry<String, List<Pattern>> e : blacklists.entrySet()) {
            Field fields = a.getFieldMap().get(e.getKey());
            if (fields == null) continue;
            FieldListImpl fl = new FieldListImpl();
            for (Field f : fields) {
                if (BlacklistAwareClusteringCombiner.isBlackListed(f.stringValue(), e.getValue())) continue;
                fl.add(f);
            }
            filtered.put(e.getKey(), fl);
        }
        return new MapDocument(a.getIdentifier(), filtered);
    }

    private static boolean isBlackListed(String value, List<Pattern> blacklist) {
        for (Pattern pattern : blacklist) {
            if (!pattern.matcher(value).matches()) continue;
            return true;
        }
        return false;
    }
}

