/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.FieldValueImpl;
import eu.dnetlib.pace.model.MapDocument;

public class MapDocumentSerializer
implements InstanceCreator<MapDocument> {
    public MapDocument createInstance(java.lang.reflect.Type type) {
        return new MapDocument();
    }

    public static MapDocument decode(String s) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Field.class, (Object)new JsonDeserializer<Field>(){

            public Field deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                FieldListImpl fl = new FieldListImpl();
                if (json.isJsonObject()) {
                    fl.add(this.handleJsonObject(json.getAsJsonObject()));
                } else if (json.isJsonArray()) {
                    for (JsonElement e : json.getAsJsonArray()) {
                        if (!e.isJsonObject()) continue;
                        fl.add(this.handleJsonObject(e.getAsJsonObject()));
                    }
                }
                return fl;
            }

            private Field handleJsonObject(JsonObject o) {
                FieldListImpl fl = new FieldListImpl();
                String name = o.get("name").getAsString();
                String type = o.get("type").getAsString();
                String value = o.get("value").getAsString();
                fl.add(new FieldValueImpl(Type.valueOf(type), name, value));
                return fl;
            }
        });
        return (MapDocument)gson.create().fromJson(s, MapDocument.class);
    }

    public static MapDocument decode(byte[] bytes) {
        return MapDocumentSerializer.decode(new String(bytes));
    }

    public static String toString(MapDocument doc) {
        GsonBuilder b = new GsonBuilder();
        return b.setPrettyPrinting().create().toJson((Object)doc);
    }

    public static byte[] toByteArray(MapDocument doc) {
        return MapDocumentSerializer.toString(doc).getBytes();
    }
}

