/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.JaroWinkler;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldList;
import eu.dnetlib.pace.model.Person;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ComparatorClass(value="authorsMatch")
public class AuthorsMatch
extends AbstractComparator {
    Map<String, String> params;
    private double SURNAME_THRESHOLD;
    private double NAME_THRESHOLD;
    private double FULLNAME_THRESHOLD;
    private String MODE;
    private int SIZE_THRESHOLD;
    private String TYPE;
    private int common;

    public AuthorsMatch(Map<String, String> params) {
        super(params, (AbstractStringDistance)new JaroWinkler());
        this.params = params;
        this.MODE = params.getOrDefault("mode", "full");
        this.SURNAME_THRESHOLD = Double.parseDouble(params.getOrDefault("surname_th", "0.95"));
        this.NAME_THRESHOLD = Double.parseDouble(params.getOrDefault("name_th", "0.95"));
        this.FULLNAME_THRESHOLD = Double.parseDouble(params.getOrDefault("fullname_th", "0.9"));
        this.SIZE_THRESHOLD = Integer.parseInt(params.getOrDefault("size_th", "20"));
        this.TYPE = params.getOrDefault("type", "percentage");
        this.common = 0;
    }

    protected AuthorsMatch(double w, AbstractStringDistance ssalgo) {
        super(w, ssalgo);
    }

    @Override
    public double compare(Field a, Field b, Config conf) {
        int normFactor;
        if (a.isEmpty() || b.isEmpty()) {
            return -1.0;
        }
        if (((FieldList)a).size() > this.SIZE_THRESHOLD || ((FieldList)b).size() > this.SIZE_THRESHOLD) {
            return 1.0;
        }
        List aList = ((FieldList)a).stringList().stream().map(author -> new Person((String)author, false)).collect(Collectors.toList());
        List bList = ((FieldList)b).stringList().stream().map(author -> new Person((String)author, false)).collect(Collectors.toList());
        this.common = 0;
        block0: for (Person p1 : aList) {
            for (Person p2 : bList) {
                String fullname2;
                String fullname1;
                if (!p1.isAccurate() && !p2.isAccurate() && this.ssalgo.score(fullname1 = this.normalization(p1.getNormalisedFullname().isEmpty() ? p1.getOriginal() : p1.getNormalisedFullname()), fullname2 = this.normalization(p2.getNormalisedFullname().isEmpty() ? p2.getOriginal() : p2.getNormalisedFullname())) > this.FULLNAME_THRESHOLD) {
                    ++this.common;
                    continue block0;
                }
                if (p1.isAccurate() ^ p2.isAccurate()) {
                    String name = this.normalization(p1.isAccurate() ? p1.getNormalisedFirstName() : p2.getNormalisedFirstName());
                    String surname = this.normalization(p1.isAccurate() ? p1.getNormalisedSurname() : p2.getNormalisedSurname());
                    String fullname = this.normalization(p1.isAccurate() ? (p2.getNormalisedFullname().isEmpty() ? p2.getOriginal() : p2.getNormalisedFullname()) : (p1.getNormalisedFullname().isEmpty() ? p1.getOriginal() : p1.getNormalisedFullname()));
                    if (fullname.contains(surname)) {
                        if (this.MODE.equals("full")) {
                            if (fullname.contains(name)) {
                                ++this.common;
                                continue block0;
                            }
                        } else {
                            ++this.common;
                            continue block0;
                        }
                    }
                }
                if (!p1.isAccurate() || !p2.isAccurate() || !this.compareSurname(p1, p2)) continue;
                if (this.MODE.equals("full")) {
                    if (!this.compareFirstname(p1, p2)) continue;
                    ++this.common;
                    continue block0;
                }
                ++this.common;
                continue block0;
            }
        }
        int n = normFactor = aList.size() == bList.size() ? aList.size() : aList.size() + bList.size() - this.common;
        if (this.TYPE.equals("percentage")) {
            return (double)this.common / (double)normFactor;
        }
        return this.common;
    }

    public boolean compareSurname(Person p1, Person p2) {
        return this.ssalgo.score(this.normalization(p1.getNormalisedSurname()), this.normalization(p2.getNormalisedSurname())) > this.SURNAME_THRESHOLD;
    }

    public boolean compareFirstname(Person p1, Person p2) {
        if ((p1.getNormalisedFirstName().length() <= 2 || p2.getNormalisedFirstName().length() <= 2) && this.firstLC(p1.getNormalisedFirstName()).equals(this.firstLC(p2.getNormalisedFirstName()))) {
            return true;
        }
        return this.ssalgo.score(this.normalization(p1.getNormalisedFirstName()), this.normalization(p2.getNormalisedFirstName())) > this.NAME_THRESHOLD;
    }

    public String normalization(String s) {
        return this.normalize(this.utf8(this.cleanup(s)));
    }
}

