/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.config.PaceConfig;
import eu.dnetlib.pace.config.WfConfig;
import eu.dnetlib.pace.model.ClusteringDef;
import eu.dnetlib.pace.model.FieldDef;
import eu.dnetlib.pace.tree.support.TreeNodeDef;
import eu.dnetlib.pace.util.PaceException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupConfig
implements Config,
Serializable {
    private static final Log log = LogFactory.getLog(DedupConfig.class);
    private static String CONFIG_TEMPLATE = "dedupConfig.st";
    private PaceConfig pace;
    private WfConfig wf;
    @JsonIgnore
    private Map<String, List<Pattern>> blacklists;
    private static Map<String, String> defaults = Maps.newHashMap();

    public static DedupConfig load(String json) {
        try {
            DedupConfig config = (DedupConfig)new ObjectMapper().readValue(json, DedupConfig.class);
            config.getPace().initModel();
            config.getPace().initTranslationMap();
            config.blacklists = config.getPace().getBlacklists().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((List)e.getValue()).stream().filter(s -> !StringUtils.isBlank((CharSequence)s)).map(Pattern::compile).collect(Collectors.toList())));
            return config;
        }
        catch (IOException e2) {
            throw new PaceException("Error in parsing configuration json", e2);
        }
    }

    public static DedupConfig loadDefault() throws IOException {
        return DedupConfig.loadDefault(new HashMap<String, String>());
    }

    public static DedupConfig loadDefault(Map<String, String> params) throws IOException {
        StringTemplate template = new StringTemplate(new DedupConfig().readFromClasspath(CONFIG_TEMPLATE));
        for (Map.Entry<String, String> e : defaults.entrySet()) {
            template.setAttribute(e.getKey(), (Object)e.getValue());
        }
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (template.getAttribute(e.getKey()) != null) {
                template.getAttributes().computeIfPresent(e.getKey(), (o, o2) -> (String)e.getValue());
                continue;
            }
            template.setAttribute(e.getKey(), (Object)e.getValue());
        }
        String json = template.toString();
        return DedupConfig.load(json);
    }

    private String readFromClasspath(String resource) throws IOException {
        return IOUtils.toString((URL)this.getClass().getResource(resource), (Charset)StandardCharsets.UTF_8);
    }

    public PaceConfig getPace() {
        return this.pace;
    }

    public void setPace(PaceConfig pace) {
        this.pace = pace;
    }

    public WfConfig getWf() {
        return this.wf;
    }

    public void setWf(WfConfig wf) {
        this.wf = wf;
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new PaceException("unable to serialise configuration", e);
        }
    }

    @Override
    public Map<String, TreeNodeDef> decisionTree() {
        return this.getPace().getDecisionTree();
    }

    @Override
    public List<FieldDef> model() {
        return this.getPace().getModel();
    }

    @Override
    public Map<String, FieldDef> modelMap() {
        return this.getPace().getModelMap();
    }

    @Override
    public List<ClusteringDef> clusterings() {
        return this.getPace().getClustering();
    }

    @Override
    public Map<String, List<Pattern>> blacklists() {
        return this.blacklists;
    }

    @Override
    public Map<String, String> translationMap() {
        return this.getPace().translationMap();
    }

    static {
        defaults.put("dedupRun", "001");
        defaults.put("entityType", "result");
        defaults.put("subEntityType", "resulttype");
        defaults.put("subEntityValue", "publication");
        defaults.put("orderField", "title");
        defaults.put("queueMaxSize", "2000");
        defaults.put("groupMaxSize", "10");
        defaults.put("slidingWindowSize", "200");
        defaults.put("rootBuilder", "result");
        defaults.put("includeChildren", "true");
        defaults.put("maxIterations", "20");
        defaults.put("idPath", "$.id");
    }
}

