/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import com.ibm.icu.text.Transliterator;
import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.model.ClusteringDef;
import eu.dnetlib.pace.model.FieldDef;
import eu.dnetlib.pace.tree.support.TreeNodeDef;
import eu.dnetlib.pace.util.PaceResolver;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class PaceConfig
extends AbstractPaceFunctions
implements Serializable {
    private List<FieldDef> model;
    private List<ClusteringDef> clustering;
    private Map<String, TreeNodeDef> decisionTree;
    private Map<String, List<String>> blacklists;
    private Map<String, List<String>> synonyms;
    @JsonIgnore
    private Map<String, String> translationMap;
    @JsonIgnore
    private Map<String, FieldDef> modelMap;
    @JsonIgnore
    public static PaceResolver resolver = new PaceResolver();

    public void initModel() {
        this.modelMap = Maps.newHashMap();
        for (FieldDef fd : this.getModel()) {
            this.modelMap.put(fd.getName(), fd);
        }
    }

    public void initTranslationMap() {
        this.translationMap = Maps.newHashMap();
        Transliterator transliterator = Transliterator.getInstance((String)"Any-Eng");
        for (String key : this.synonyms.keySet()) {
            for (String term : this.synonyms.get(key)) {
                this.translationMap.put(PaceConfig.fixAliases(transliterator.transliterate(term.toLowerCase())), key);
            }
        }
    }

    public Map<String, String> translationMap() {
        return this.translationMap;
    }

    public List<FieldDef> getModel() {
        return this.model;
    }

    public void setModel(List<FieldDef> model) {
        this.model = model;
    }

    public List<ClusteringDef> getClustering() {
        return this.clustering;
    }

    public void setClustering(List<ClusteringDef> clustering) {
        this.clustering = clustering;
    }

    public Map<String, TreeNodeDef> getDecisionTree() {
        return this.decisionTree;
    }

    public void setDecisionTree(Map<String, TreeNodeDef> decisionTree) {
        this.decisionTree = decisionTree;
    }

    public Map<String, List<String>> getBlacklists() {
        return this.blacklists;
    }

    public void setBlacklists(Map<String, List<String>> blacklists) {
        this.blacklists = blacklists;
    }

    public Map<String, List<String>> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Map<String, List<String>> synonyms) {
        this.synonyms = synonyms;
    }

    public Map<String, FieldDef> getModelMap() {
        return this.modelMap;
    }

    public void setModelMap(Map<String, FieldDef> modelMap) {
        this.modelMap = modelMap;
    }
}

