/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.collect.Sets;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.ClusteringDef;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldValueImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ClusteringCombiner {
    private static String SEPARATOR = ":";
    private static String COLLAPSE_ON = "collapseOn";

    public static Collection<String> combine(Document a, Config conf) {
        LinkedHashSet res = Sets.newLinkedHashSet();
        for (ClusteringDef cd : conf.clusterings()) {
            for (String fieldName : cd.getFields()) {
                String prefix = ClusteringCombiner.getPrefix(cd, fieldName);
                Field values = a.values(fieldName);
                ArrayList<Field> fields = new ArrayList<Field>();
                if (values instanceof FieldValueImpl) {
                    fields.add(values);
                } else {
                    fields.addAll((List)((Object)values));
                }
                res.addAll(cd.clusteringFunction().apply(conf, fields).stream().map(k -> prefix + SEPARATOR + k).collect(Collectors.toList()));
            }
        }
        return res;
    }

    private static String getPrefix(ClusteringDef cd, String fieldName) {
        return cd.getName() + SEPARATOR + cd.getParams().keySet().stream().filter(k -> k.contains(COLLAPSE_ON)).findFirst().map(k -> StringUtils.substringAfter((String)k, (String)SEPARATOR)).orElse(fieldName);
    }
}

