/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.s3;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFileNotFoundException;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.data.objectstore.s3.S3ObjectStore;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Value;

public class S3ObjectStoreDao
implements ObjectStoreDao {
    public static final String INTERPRETATION_FIELD = "interpretation";
    public static final String OBJECTSTORE_METADATA_NAME_FIELD = "metadataObjectStore";
    public static final String OBJECTSTORE_ID_FIELD = "obsId";
    private static final String OBJECTSTORE_PROFILE_SUFFIX = "_T2JqZWN0U3RvcmVEU1Jlc291cmNlcy9PYmplY3RTdG9yZURTUmVzb3VyY2VUeXBl";
    private static final Log log = LogFactory.getLog(S3ObjectStoreDao.class);
    private static final List<IndexModel> metadataIndexes = Arrays.asList(new IndexModel((Bson)new Document().append("id", (Object)1)), new IndexModel((Bson)new Document().append("timestamp", (Object)1)));
    @Resource(name="objectstoreMongoDB")
    private MongoDatabase db;
    @Value(value="${dnet.objectStore.s3.accessKey}")
    private String accessKey;
    @Value(value="${dnet.objectStore.s3.secretKey}")
    private String secretKey;
    @Value(value="${dnet.objectStore.s3.endPoint}")
    private String s3EndPoint;
    @Value(value="${dnet.objectStore.s3.objectStoreBucket}")
    private String objectStoreBucket;

    private Document getObjectStoreMetadata(String objectStoreId) {
        String find_id = objectStoreId;
        if (objectStoreId.length() == 36) {
            find_id = find_id + OBJECTSTORE_PROFILE_SUFFIX;
        }
        MongoCollection metadataObjectStore = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD);
        Bson query = Filters.eq((String)OBJECTSTORE_ID_FIELD, (Object)find_id);
        log.debug((Object)("QUERY :" + query.toString()));
        Document resultQuery = (Document)metadataObjectStore.find(query).first();
        log.debug((Object)("result " + resultQuery));
        return resultQuery;
    }

    public ObjectStore getObjectStore(String objectStoreId) throws ObjectStoreServiceException {
        if (StringUtils.isBlank((CharSequence)objectStoreId)) {
            throw new ObjectStoreServiceException("Error on getting ObjectStore, id is Blank");
        }
        Document resultQuery = this.getObjectStoreMetadata(objectStoreId);
        if (resultQuery == null) {
            throw new ObjectStoreFileNotFoundException("the objectStore with identifier: " + objectStoreId + " was not found");
        }
        MongoCollection collection = this.getDb().getCollection(objectStoreId.substring(0, 36));
        collection.createIndexes(metadataIndexes);
        return new S3ObjectStore(resultQuery.getString((Object)OBJECTSTORE_ID_FIELD), resultQuery.getString((Object)INTERPRETATION_FIELD), this.accessKey, this.secretKey, this.s3EndPoint, this.objectStoreBucket, (MongoCollection<Document>)collection);
    }

    public List<String> listObjectStores() {
        MongoCollection metadata = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD);
        Iterable tmp = () -> metadata.find().iterator();
        return StreamSupport.stream(tmp.spliterator(), false).map(it -> it.getString((Object)OBJECTSTORE_ID_FIELD)).collect(Collectors.toList());
    }

    public boolean createObjectStore(String obsId, String interpretation, String basePath) throws ObjectStoreServiceException {
        if (this.getObjectStoreMetadata(obsId) != null) {
            throw new ObjectStoreServiceException("Error unable to create an ObjectStore that already exists in mongo");
        }
        MongoCollection metadata = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD);
        Document item = new Document().append(OBJECTSTORE_ID_FIELD, (Object)obsId).append(INTERPRETATION_FIELD, (Object)interpretation);
        metadata.insertOne((Object)item);
        MongoCollection objectStore = this.getDb().getCollection(obsId.substring(0, 36));
        objectStore.createIndex((Bson)new BasicDBObject("id", (Object)1));
        objectStore.createIndex((Bson)new BasicDBObject("timestamp", (Object)1));
        return true;
    }

    public boolean updateObjectStore(String obsId, String interpretation) {
        MongoCollection coll = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD);
        Document update = new Document().append("$set", (Object)new Document(INTERPRETATION_FIELD, (Object)interpretation));
        UpdateResult updateResult = coll.updateOne(Filters.eq((String)OBJECTSTORE_ID_FIELD, (Object)obsId), (Bson)update);
        if (updateResult.isModifiedCountAvailable()) {
            log.debug((Object)("Matched / Modified " + updateResult.getMatchedCount() + " / " + updateResult.getModifiedCount()));
        }
        return true;
    }

    public boolean deleteObjectStore(String obsId) throws ObjectStoreServiceException {
        Document objectStoreMetadata = this.getObjectStoreMetadata(obsId);
        if (objectStoreMetadata == null) {
            throw new ObjectStoreServiceException("ObjectStore not found with Identifier " + obsId);
        }
        log.debug((Object)"Start to deleting all the object on the ObjectStore in teh bucket");
        this.getObjectStore(obsId.substring(0, 36)).dropContent();
        log.debug((Object)"All object Deleted");
        log.debug((Object)"Deleting mongo collection");
        MongoCollection objectStoreCollection = this.db.getCollection(objectStoreMetadata.getString((Object)OBJECTSTORE_ID_FIELD));
        objectStoreCollection.drop();
        log.debug((Object)"Deleting item on mongo metadata Collection");
        MongoCollection metadata = this.getDb().getCollection(OBJECTSTORE_METADATA_NAME_FIELD);
        DeleteResult deleteResult = metadata.deleteOne(Filters.eq((String)OBJECTSTORE_ID_FIELD, (Object)obsId));
        if (deleteResult.getDeletedCount() != 1L) {
            throw new ObjectStoreServiceException("Unexpected number of Deleting object on ObjectStoreMetadata, should be 1 instead of" + deleteResult.getDeletedCount());
        }
        return true;
    }

    public boolean dropContent(String obsId) throws ObjectStoreServiceException {
        return this.getObjectStore(obsId).dropContent();
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    public void setDb(MongoDatabase db) {
        this.db = db;
    }
}

