/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.collect.Lists;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import eu.dnetlib.data.objectstore.modular.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.rmi.MetadataObjectRecord;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.data.objectstore.s3.ObjectStoreS3Utility;
import eu.dnetlib.data.objectstore.s3.S3ObjectStoreResultSetListener;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;

public class S3ObjectStore
implements ObjectStore {
    private static final String S3_REGION = "eu-west-3";
    private static final String URI_FIELD = "uri";
    private static final String ID_FIELD = "id";
    private static final String MIME_FIELD = "mime";
    private static final String ORIGINAL_OBJECT_FIELD = "originalObject";
    private static final String TIMESTAMP_FIELD = "timestamp";
    private static final String MD5_FIELD = "md5Sum";
    private static final String SIZE_FIELD = "size";
    private final String id;
    private final String interpretation;
    private final String s3AccessKey;
    private final String s3SecretKey;
    private final String s3EndPoint;
    private final String objectStoreBucket;
    private final MongoCollection<Document> mongoCollection;
    private AmazonS3 client;
    private static final Log log = LogFactory.getLog(S3ObjectStore.class);

    public S3ObjectStore(String identifier, String interpretation, String s3AccessKey, String s3SecretKey, String s3EndPoint, String objectStoreBucket, MongoCollection<Document> mongoCollection) throws ObjectStoreServiceException {
        this.id = identifier;
        this.interpretation = interpretation;
        this.s3AccessKey = s3AccessKey;
        this.s3SecretKey = s3SecretKey;
        this.mongoCollection = mongoCollection;
        this.s3EndPoint = s3EndPoint;
        this.objectStoreBucket = objectStoreBucket;
    }

    private AmazonS3 initializeClient() throws ObjectStoreServiceException {
        try {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.s3AccessKey, this.s3SecretKey);
            ClientConfiguration cfg = new ClientConfiguration().withProtocol(Protocol.HTTPS);
            AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withClientConfiguration(cfg)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.s3EndPoint, S3_REGION))).build();
            if (s3 == null) {
                throw new ObjectStoreServiceException("Cannot initialize s3 client because is NULL");
            }
            return s3;
        }
        catch (Throwable e) {
            log.error((Object)"An Error happen on initialize client ", e);
            throw new ObjectStoreServiceException("Cannot initialize s3 client", e);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public int feed(Iterable<ObjectStoreRecord> iterable, boolean upsert) throws ObjectStoreServiceException {
        AtomicInteger count = new AtomicInteger();
        iterable.forEach(objectStoreRecord -> {
            try {
                this.feedObjectRecord((ObjectStoreRecord)objectStoreRecord);
                count.incrementAndGet();
            }
            catch (ObjectStoreServiceException e) {
                log.error((Object)"Error on saving file in a temporary Folder");
            }
        });
        return count.intValue();
    }

    public int feedMetadataRecord(Iterable<MetadataObjectRecord> iterable, boolean b) throws ObjectStoreServiceException {
        AtomicInteger count = new AtomicInteger();
        iterable.forEach(mor -> {
            ObjectStoreRecord r = new ObjectStoreRecord();
            r.setInputStream((InputStream)new ByteArrayInputStream(mor.getRecord().getBytes()));
            ObjectStoreFile fileMetadata = new ObjectStoreFile();
            fileMetadata.setObjectID(mor.getId());
            fileMetadata.setMimeType(mor.getMime());
            r.setFileMetadata(fileMetadata);
            try {
                this.feedObjectRecord(r);
                count.incrementAndGet();
            }
            catch (ObjectStoreServiceException e) {
                log.error((Object)"Unable to store record r", (Throwable)e);
            }
        });
        return count.intValue();
    }

    public String feedObjectRecord(ObjectStoreRecord objectStoreRecord) throws ObjectStoreServiceException {
        if (this.client == null) {
            this.client = this.initializeClient();
        }
        try {
            long start = System.currentTimeMillis();
            if (objectStoreRecord != null && objectStoreRecord.getInputStream() != null) {
                log.debug((Object)("Saving object with ID: " + objectStoreRecord.getFileMetadata().getObjectID() + " on s3 "));
                this.client.putObject(this.objectStoreBucket, this.id + "/" + objectStoreRecord.getFileMetadata().getObjectID(), objectStoreRecord.getInputStream(), null);
                S3Object s3Object = this.client.getObject(this.objectStoreBucket, this.id + "/" + objectStoreRecord.getFileMetadata().getObjectID());
                log.debug((Object)("Total time to put into the ObjectStore " + (System.currentTimeMillis() - start)));
                log.debug((Object)"Saved object on s3 ");
                double timestamp = System.currentTimeMillis();
                Document metadata = new Document().append(ID_FIELD, (Object)objectStoreRecord.getFileMetadata().getObjectID()).append(MIME_FIELD, (Object)objectStoreRecord.getFileMetadata().getMimeType()).append(ORIGINAL_OBJECT_FIELD, (Object)objectStoreRecord.getFileMetadata().toJSON()).append(TIMESTAMP_FIELD, (Object)timestamp).append(MD5_FIELD, (Object)s3Object.getObjectMetadata().getETag()).append(SIZE_FIELD, (Object)s3Object.getObjectMetadata().getContentLength()).append(URI_FIELD, (Object)String.format("s3://%s/%s/%s", this.objectStoreBucket, this.id, objectStoreRecord.getFileMetadata().getObjectID()));
                log.debug((Object)("saving metadata object to the collection: " + metadata.toString()));
                start = System.currentTimeMillis();
                this.mongoCollection.insertOne((Object)metadata);
                log.debug((Object)("Total time to save in Mongo " + (System.currentTimeMillis() - start)));
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error on put file in the objectStore", e);
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new ObjectStoreServiceException(e);
        }
        return null;
    }

    public ResultSetListener deliver(Long from, Long until) throws ObjectStoreServiceException {
        S3ObjectStoreResultSetListener resultSet = new S3ObjectStoreResultSetListener();
        resultSet.setMongoCollection(this.mongoCollection);
        resultSet.setObjectStoreID(this.getId());
        resultSet.setFromDate(from);
        resultSet.setUntilDate(until);
        return resultSet;
    }

    public ResultSetListener deliverIds(Iterable<String> ids) throws ObjectStoreServiceException {
        S3ObjectStoreResultSetListener resultSet = new S3ObjectStoreResultSetListener();
        resultSet.setMongoCollection(this.mongoCollection);
        resultSet.setObjectStoreID(this.getId());
        resultSet.setRecords(Lists.newArrayList(ids));
        return resultSet;
    }

    public ObjectStoreFile deliverObject(String objectId) throws ObjectStoreServiceException {
        Document resultQuery = (Document)this.mongoCollection.find(Filters.eq((String)ID_FIELD, (Object)objectId)).first();
        if (resultQuery != null) {
            return ObjectStoreS3Utility.build(resultQuery);
        }
        return null;
    }

    public int getSize() throws ObjectStoreServiceException {
        return (int)this.mongoCollection.count();
    }

    public void deleteObject(String objectId) throws ObjectStoreServiceException {
        Document response = (Document)this.mongoCollection.findOneAndDelete(Filters.eq((String)ID_FIELD, (Object)objectId));
        if (response == null) {
            throw new ObjectStoreServiceException("Error document not found with objectId: " + objectId);
        }
        if (this.client == null) {
            this.client = this.initializeClient();
        }
        this.client.deleteObject(this.objectStoreBucket, String.format("%s/%s", this.id, response.get((Object)ID_FIELD)));
    }

    public String getObject(String objectId) throws ObjectStoreServiceException {
        Document response = (Document)this.mongoCollection.find(Filters.eq((String)ID_FIELD, (Object)objectId)).first();
        if (response == null || !response.containsKey((Object)URI_FIELD)) {
            return null;
        }
        return response.getString((Object)URI_FIELD);
    }

    public boolean existIDStartsWith(String startId) throws ObjectStoreServiceException {
        return this.mongoCollection.count(Filters.regex((String)ID_FIELD, (Pattern)Pattern.compile(startId))) > 0L;
    }

    public boolean dropContent() throws ObjectStoreServiceException {
        ListObjectsV2Result result;
        if (this.client == null) {
            this.client = this.initializeClient();
        }
        ListObjectsV2Request req = new ListObjectsV2Request().withBucketName(this.objectStoreBucket).withPrefix(this.id);
        do {
            result = this.client.listObjectsV2(req);
            for (S3ObjectSummary objectSummary : result.getObjectSummaries()) {
                log.debug((Object)String.format(" - %s (size: %d)\n", objectSummary.getKey(), objectSummary.getSize()));
                this.client.deleteObject(this.objectStoreBucket, objectSummary.getKey());
                log.debug((Object)"Object Deleted");
            }
            String token = result.getNextContinuationToken();
            log.debug((Object)("Next Continuation Token: " + token));
            req.setContinuationToken(token);
        } while (result.isTruncated());
        this.mongoCollection.drop();
        return true;
    }
}

