/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.s3;

import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;

public class ObjectStoreS3Utility {
    private static final int KB_SIZE = 1024;
    private static final Log log = LogFactory.getLog(ObjectStoreS3Utility.class);

    public static ObjectStoreFile build(Document metadata) {
        String originalFile = metadata.getString((Object)"originalObject");
        ObjectStoreFile original = ObjectStoreFile.createObject((String)originalFile);
        ObjectStoreFile newFile = new ObjectStoreFile();
        newFile.setObjectID(metadata.getString((Object)"id"));
        newFile.setAccessProtocol(Protocols.None);
        newFile.setMimeType(metadata.getString((Object)"mime"));
        newFile.setMd5Sum(metadata.getString((Object)"md5Sum"));
        try {
            newFile.setFileSizeKB(Long.parseLong(metadata.get((Object)"size").toString()) / 1024L);
        }
        catch (Throwable e) {
            log.error((Object)"Error on getting file size", e);
        }
        if (originalFile != null) {
            newFile.setMetadataRelatedID(original.getMetadataRelatedID());
            if (StringUtils.isBlank((CharSequence)original.getDownloadedURL())) {
                newFile.setDownloadedURL(original.getURI());
            } else {
                newFile.setDownloadedURL(original.getDownloadedURL());
            }
        }
        newFile.setURI(metadata.get((Object)"uri").toString());
        return newFile;
    }

    public static UnaryFunction<String, Document> asJSON() {
        return input -> ObjectStoreS3Utility.build(input).toJSON();
    }
}

