package eu.dnetlib.data.objectstore.s3;

import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.bson.Document;


/**
 * The Class ObjectStoreFileBuilder generates an objectStoreFile bean
 */
public class ObjectStoreS3Utility {

    private static final int KB_SIZE = 1024;

    /**
     * The Constant log.
     */
    private static final Log log = LogFactory.getLog(ObjectStoreS3Utility.class);

    public static ObjectStoreFile build(final Document metadata) {

        final String originalFile = metadata.getString("originalObject");
        final ObjectStoreFile original = ObjectStoreFile.createObject(originalFile);
        final ObjectStoreFile newFile = new ObjectStoreFile();
        newFile.setObjectID(metadata.getString("id"));
        newFile.setAccessProtocol(Protocols.None);
        newFile.setMimeType( metadata.getString("mime"));
        newFile.setMd5Sum(metadata.getString("md5Sum"));
        try {
            newFile.setFileSizeKB(Long.parseLong(metadata.get("size").toString()) / KB_SIZE);
        } catch (Throwable e) {
            log.error("Error on getting file size", e);
        }
        if (originalFile != null) {
            newFile.setMetadataRelatedID(original.getMetadataRelatedID());
            if (StringUtils.isBlank(original.getDownloadedURL())) {
                newFile.setDownloadedURL(original.getURI());
            } else {
                newFile.setDownloadedURL(original.getDownloadedURL());
            }
        }
        newFile.setURI(metadata.get("uri").toString());
        return newFile;
    }

    public static UnaryFunction<String, Document> asJSON() {
        return input -> build(input).toJSON();
    }
}
