/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.miscutils.datetime.HumanTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ModularObjectStoreRESTService {
    private static final Log log = LogFactory.getLog(ModularObjectStoreRESTService.class);
    @Value(value="${dnet.objectStore.s3.accessKey}")
    private String accessKey;
    @Value(value="${dnet.objectStore.s3.secretKey}")
    private String secretKey;
    @Value(value="${dnet.objectStore.s3.endPoint}")
    private String s3EndPoint;
    @Value(value="${dnet.objectStore.s3.objectStoreBucket}")
    private String objectStoreBucket;
    private AmazonS3 client;
    private static final String S3_REGION = "eu-west-3";

    private AmazonS3 initializeClient() throws ObjectStoreServiceException {
        try {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
            ClientConfiguration cfg = new ClientConfiguration().withProtocol(Protocol.HTTPS);
            AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withClientConfiguration(cfg)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.s3EndPoint, S3_REGION))).build();
            if (s3 == null) {
                throw new ObjectStoreServiceException("Cannot initialize s3 client because is NULL");
            }
            return s3;
        }
        catch (Throwable e) {
            log.error((Object)"An Error happen on initialize client ", e);
            throw new ObjectStoreServiceException("Cannot initialize s3 client", e);
        }
    }

    public static String retrieveURL(String baseURI, String basePath, String objectStoreId, String objectId) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(baseURI).append("?objectStore=" + ModularObjectStoreRESTService.encode(objectStoreId)).append("&objectId=" + ModularObjectStoreRESTService.encode(objectId)).append("&basePath=" + ModularObjectStoreRESTService.encode(basePath));
        return sb.toString();
    }

    private static String encode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    @RequestMapping(value={"/**/objectStore/retrieve.do"})
    public void retrieve(HttpServletResponse res, @RequestParam(value="objectStore", required=true) String objectStoreId, @RequestParam(value="objectId", required=true) String objectId) throws IOException, ObjectStoreServiceException {
        S3Object object;
        long start = System.currentTimeMillis();
        if (this.client == null) {
            this.client = this.initializeClient();
        }
        if ((object = this.client.getObject(this.objectStoreBucket, objectStoreId + "/" + objectId)) == null) {
            String msg = String.format("Object with identifier: %s not found the in %s", objectId, objectStoreId);
            res.sendError(404, msg);
            log.warn((Object)msg);
        } else {
            try (S3ObjectInputStream is = object.getObjectContent();){
                res.setHeader("Content-Length", String.valueOf(object.getObjectMetadata().getContentLength()));
                IOUtils.copyLarge((InputStream)is, (OutputStream)res.getOutputStream());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("retrive.do completed in %s, objId: %s", HumanTime.exactly((long)(System.currentTimeMillis() - start)), objectId));
                }
            }
            catch (IOException e) {
                String msg = "unable to close input Stream";
                res.sendError(500, "unable to close input Stream");
                log.error((Object)"unable to close input Stream", (Throwable)e);
            }
        }
    }
}

