package eu.dnetlib.msro.workflows.nodes.validation;

import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetInfoForValidationJobNode extends SimpleJobNode {

	public static final Log log = LogFactory.getLog(SetInfoForValidationJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private UniqueServiceLocator serviceLocator;
	private String profileId;
	private String providerName;
	private String api;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ID, getProfileId());
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAME, getProviderName());
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE, getApi());

		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ID, getProfileId());
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAME, getProviderName());
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE, getApi());

		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ID, getProfileId());
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAME, getProviderName());
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE, getApi());

		final String query = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='" + getProfileId() + "']\n"
				+ "return concat($x//DATASOURCE_ORIGINAL_ID/text(), '@@@', $x//EXTRA_FIELDS/FIELD[./key='NamespacePrefix']/value, '@@@', $x//INTERFACE[./@id='"
				+ getApi() + "']/BASE_URL/text())";

		final String[] arr = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query).split("@@@");
		final String origId = arr[0].trim();
		final String nsPrefix = arr[1].trim();
		final String interfaceURL = arr[2].trim();

		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, origId);
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE_BASEURL, interfaceURL);

		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, origId);
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE_BASEURL, interfaceURL);

		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, origId);
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE_BASEURL, interfaceURL);

		return Arc.DEFAULT_ARC;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setProviderName(final String providerName) {
		this.providerName = providerName;
	}

	public String getApi() {
		return api;
	}

	public void setApi(final String api) {
		this.api = api;
	}

	public String getProfileId() {
		return profileId;
	}

	public void setProfileId(final String profileId) {
		this.profileId = profileId;
	}
}
