package eu.dnetlib.gwt.server.help;

import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.server.service.SpringGwtRemoteServiceServlet;
import eu.dnetlib.gwt.shared.Help;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by stefania on 3/9/16.
 */
@Service("helpService")
@Transactional
public class HelpServiceImpl extends SpringGwtRemoteServiceServlet implements HelpService {

    @Autowired
    private HelpDAO helpDAO;

    @Override
    public Help saveHelp(Help help) {
        return helpDAO.saveHelp(help);
    }

    @Override
    public Help getHelpById(String id) {
        try {
            return helpDAO.getById(id);
        } catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<Help> getAll() {
        return helpDAO.getAll();
    }

    @Override
    public void delete(String helpId) {
        helpDAO.delete(helpId);
    }
}
