package eu.dnetlib.gwt.client;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.InlineHelpBlock;
import org.gwtbootstrap3.client.ui.constants.ValidationState;

/**
 * Created by stefania on 12/18/15.
 */
public class MyFormGroup implements IsWidget {

    private FormGroup formGroup = new FormGroup();
    private FormLabel formLabel = new FormLabel();
    private InlineHelpBlock inlineHelpBlock = new InlineHelpBlock();

    public MyFormGroup(boolean includeHelpBlock, String labelText, Widget... widgets) {

        if(labelText!=null) {
            formLabel.setText(labelText);
            formGroup.add(formLabel);
        }

        if(includeHelpBlock) {
            inlineHelpBlock.setVisible(false);
            inlineHelpBlock.addStyleName("inline");
            formGroup.add(inlineHelpBlock);
        }

        for(Widget widget : widgets) {
            formGroup.add(widget);

//            formLabel.setFor(widget.getElement().getId());
        }
    }

    @Override
    public Widget asWidget() {
        return formGroup;
    }

    public void setFormGroupValidationState(ValidationState validationState) {
        inlineHelpBlock.setVisible(false);
        formGroup.setValidationState(validationState);
    }

    public void setLabelText(String labelText) {
        formLabel.setText(labelText);
    }

    public void displayInlineError(String errorText) {
        inlineHelpBlock.setVisible(true);
        inlineHelpBlock.setError(errorText);
        formGroup.setValidationState(ValidationState.ERROR);
    }

    public void displayInlineSuccess(String successText) {
        inlineHelpBlock.setVisible(true);
        inlineHelpBlock.setText(successText);
        formGroup.setValidationState(ValidationState.SUCCESS);
    }
}
