package eu.dnetlib.gwt.server.help;

import eu.dnetlib.gwt.shared.Help;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.List;

/**
 * Created by antleb on 4/17/15.
 */
@Component(value = "helpDAO")
public class HelpDAO {

	@Autowired
	@Qualifier("repomanager.dataSource")
	private DataSource dataSource;

	private final static String UPDATE_HELP = "update help set name=?, text=? where id=?";
	private final static String INSERT_HELP = "insert into help (name, text, id) values (?, ?, ?)";
	private final static String GET_BY_ID = "select id, name, text from help where id = ?";
	private final static String GET_ALL = "select id, name, text from help";
	private final static String DELETE = "delete from help where id = ?";


	private RowMapper<Help> helpRowMapper = new RowMapper<Help>() {
		@Override
		public Help mapRow(ResultSet rs, int i) throws SQLException {
			return new Help(rs.getString("id"), rs.getString("name"), rs.getString("text"));
		}
	};

	public Help saveHelp(Help help) {
		JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);

		if (jdbcTemplate.update(UPDATE_HELP, new String[]{help.getName(), help.getText(), help.getId()}, new int[]{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR}) == 0)
			jdbcTemplate.update(INSERT_HELP, new String[]{help.getName(), help.getText(), help.getId()}, new int[]{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR});

		return help;
	}

	public Help getById(String id) {
		return new JdbcTemplate(dataSource).queryForObject(GET_BY_ID, new String[]{id}, new int[]{Types.VARCHAR}, helpRowMapper);
	}

	public List<Help> getAll() {
		return new JdbcTemplate(dataSource).query(GET_ALL, helpRowMapper);
	}

	public void delete(String helpId) {
		new JdbcTemplate(dataSource).update(DELETE, new String[]{helpId}, new int[]{Types.VARCHAR});
	}
}