package eu.dnetlib.gwt.client.help;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import eu.dnetlib.gwt.shared.Help;

/**
 * Created by stefania on 4/17/15.
 */
public abstract class HelpHelper {

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    public static void loadHelp(final String helpId, final HelpListener helpListener) {

        helpService.getHelpById(helpId, new AsyncCallback<Help>() {

            @Override
            public void onFailure(Throwable throwable) {
                Window.alert("help failed");
            }

            @Override
            public void onSuccess(Help help) {

                Window.alert("help succeeded");

                if(help!=null) {

                    HTML html = new HTML();
                    html.setHTML(help.getText());

                    helpListener.helpLoaded(html);

//                    helpPanel.clearContent();
//                    helpPanel.addContent(html);
//
//                    HelpHelper.showSidebar();
//                    RootPanel.get("sidebar").add(helpPanel.asWidget());
                }
            }
        });
    }

    public interface HelpListener {
        void helpLoaded(HTML help);
    }

//    public static void showSidebar() {
//
//        Document.get().getElementById("content").removeClassName("uk-width-medium-1-1");
//        Document.get().getElementById("content").addClassName("uk-width-medium-3-4");
//        Document.get().getElementById("sidebar").getStyle().setDisplay(Style.Display.BLOCK);
//    }
//
//    public static void hideSidebar() {
//
//        Document.get().getElementById("content").removeClassName("uk-width-medium-3-4");
//        Document.get().getElementById("content").addClassName("uk-width-medium-1-1");
//        Document.get().getElementById("sidebar").getStyle().setDisplay(Style.Display.NONE);
//    }
}
