/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.controllers;

import com.google.common.collect.Lists;
import eu.dnetlib.lbs.controllers.AbstractLbsController;
import eu.dnetlib.lbs.cron.ScheduledActions;
import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.elasticsearch.EventRepository;
import eu.dnetlib.lbs.elasticsearch.EventStatsManager;
import eu.dnetlib.lbs.subscriptions.Subscription;
import eu.dnetlib.lbs.subscriptions.SubscriptionRepository;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/events"})
@Api(tags={"Events"})
public class EventsController
extends AbstractLbsController {
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private EventStatsManager eventStatsManager;
    @Autowired
    private ScheduledActions scheduledActions;

    @ApiOperation(value="Return an event by ID")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public Event getEvent(@PathVariable String id) {
        return (Event)this.eventRepository.findById((Object)id).get();
    }

    @ApiOperation(value="Delete an event by ID")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void deleteEvent(@PathVariable String id) {
        this.eventRepository.deleteById((Object)id);
    }

    @ApiOperation(value="Save an event by ID")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public Event saveEvent(@RequestBody Event event) {
        return (Event)this.eventRepository.save((Object)event);
    }

    @ApiOperation(value="Return a page of events")
    @RequestMapping(value={"/list/{page}/{pageSize}"}, method={RequestMethod.GET})
    public List<Event> events(@PathVariable int page, @PathVariable int pageSize) {
        return Lists.newArrayList((Iterable)this.eventRepository.findAll((Pageable)PageRequest.of((int)page, (int)pageSize)));
    }

    @ApiOperation(value="Return a page of events by topic")
    @RequestMapping(value={"/byTopic/{page}/{pageSize}"}, method={RequestMethod.GET})
    public List<Event> eventsByTopic(@PathVariable int page, @PathVariable int pageSize, @RequestParam String topic) {
        return Lists.newArrayList((Iterable)this.eventRepository.findByTopic(QueryParserUtil.escape((String)topic), (Pageable)PageRequest.of((int)page, (int)pageSize)));
    }

    @ApiOperation(value="Delete all the events")
    @RequestMapping(value={"/all"}, method={RequestMethod.DELETE})
    public Map<String, Object> clearEvents() {
        this.eventRepository.deleteAll();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("deleted", true);
        return res;
    }

    @ApiOperation(value="Delete the expired events")
    @RequestMapping(value={"/expired"}, method={RequestMethod.DELETE})
    public Map<String, Long> deleteExpiredEvents() {
        HashMap<String, Long> res = new HashMap<String, Long>();
        res.put("deleted", this.scheduledActions.deleteExpiredEvents());
        return res;
    }

    @ApiOperation(value="Return the topics of the indexed events (all)")
    @RequestMapping(value={"/topics/all"}, method={RequestMethod.GET})
    public List<EventStatsManager.BrowseEntry> browseTopics() {
        return this.eventStatsManager.browseTopics();
    }

    @ApiOperation(value="Return the topics of the indexed events (only with subscriptions)")
    @RequestMapping(value={"/topics/withSubscriptions"}, method={RequestMethod.GET})
    public List<EventStatsManager.BrowseEntry> browseTopicsWithSubscriptions() {
        Iterable iter = this.subscriptionRepo.findAll();
        Set validTopics = StreamSupport.stream(iter.spliterator(), false).map(Subscription::getTopic).collect(Collectors.toSet());
        return this.browseTopics().stream().filter(e -> validTopics.contains(e.getValue())).collect(Collectors.toList());
    }
}

