/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.controllers;

import eu.dnetlib.lbs.controllers.SubscriptionsController;
import eu.dnetlib.lbs.subscriptions.MapCondition;
import eu.dnetlib.lbs.subscriptions.NotificationFrequency;
import eu.dnetlib.lbs.subscriptions.NotificationMode;
import eu.dnetlib.lbs.subscriptions.Subscription;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

class InSubscription {
    private String subscriber;
    private String topic;
    private NotificationFrequency frequency;
    private NotificationMode mode;
    private List<MapCondition> conditions;

    public InSubscription() {
    }

    public InSubscription(String subscriber, String topic, NotificationFrequency frequency, NotificationMode mode, List<MapCondition> conditions) {
        this.subscriber = subscriber;
        this.topic = topic;
        this.frequency = frequency;
        this.mode = mode;
        this.conditions = conditions;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(String subscriber) {
        this.subscriber = subscriber;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public NotificationFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(NotificationFrequency frequency) {
        this.frequency = frequency;
    }

    public NotificationMode getMode() {
        return this.mode;
    }

    public void setMode(NotificationMode mode) {
        this.mode = mode;
    }

    public List<MapCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<MapCondition> conditions) {
        this.conditions = conditions;
    }

    public Subscription asSubscription() {
        if (StringUtils.isBlank((CharSequence)this.subscriber)) {
            throw new IllegalArgumentException("subscriber is empty");
        }
        if (StringUtils.isBlank((CharSequence)this.topic)) {
            throw new IllegalArgumentException("topic is empty");
        }
        if (!SubscriptionsController.verifyEmail.test(this.subscriber)) {
            throw new IllegalArgumentException("Invalid email: " + this.subscriber);
        }
        if (!SubscriptionsController.verifyTopic.test(this.topic)) {
            throw new IllegalArgumentException("Invalid topic: " + this.topic);
        }
        String subscriptionId = "sub-" + UUID.randomUUID();
        return new Subscription(subscriptionId, this.subscriber, this.topic, this.frequency, this.mode, null, new Date(), this.conditions);
    }
}

