/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.controllers;

import eu.dnetlib.lbs.controllers.AbstractLbsController;
import eu.dnetlib.lbs.controllers.InSubscription;
import eu.dnetlib.lbs.cron.ScheduledActions;
import eu.dnetlib.lbs.elasticsearch.NotificationRepository;
import eu.dnetlib.lbs.matchers.SubscriptionEventMatcher;
import eu.dnetlib.lbs.subscriptions.Subscription;
import eu.dnetlib.lbs.subscriptions.SubscriptionRepository;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subscriptions"})
@Api(tags={"Subscriptions"})
public class SubscriptionsController
extends AbstractLbsController {
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private NotificationRepository notificationRepo;
    @Autowired
    private ScheduledActions schedulerActions;
    @Autowired
    private SubscriptionEventMatcher subscriptionEventMatcher;
    public static final Predicate<String> verifyTopic = Pattern.compile("^[a-zA-Z0-9._-]+(\\/[a-zA-Z0-9._-]+)+$").asPredicate();
    public static final Predicate<String> verifyEmail = new /* Unavailable Anonymous Inner Class!! */;

    @ApiOperation(value="Return the list of subscriptions")
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Iterable<Subscription> listSubscriptions() {
        return this.subscriptionRepo.findAll();
    }

    @ApiOperation(value="Return a subscription by ID")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public Subscription getSubscription(@PathVariable String id) {
        return (Subscription)this.subscriptionRepo.findById((Object)id).get();
    }

    @ApiOperation(value="Delete a subscription by ID and its notifications")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void deleteSubscription(@PathVariable String id) {
        this.subscriptionRepo.deleteById((Object)id);
        this.notificationRepo.deleteBySubscriptionId(id);
    }

    @ApiOperation(value="Perform a new subscription")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public Subscription registerSubscription(@RequestBody InSubscription inSub) {
        Subscription sub = inSub.asSubscription();
        this.subscriptionRepo.save((Object)sub);
        return sub;
    }

    @ApiOperation(value="Delete all subscriptions and notifications")
    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    public Map<String, Object> clearSubscriptions() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        this.subscriptionRepo.deleteAll();
        this.notificationRepo.deleteAll();
        res.put("deleted", "all");
        return res;
    }

    @ApiOperation(value="Launch the thread that produces new notifications")
    @RequestMapping(value={"/startMatching"}, method={RequestMethod.GET})
    public List<String> startMatching() {
        this.schedulerActions.startSubscriptionEventsMatcher();
        return Arrays.asList("done");
    }

    @ApiOperation(value="Launch the thread that produces new notifications by subscriptuion id")
    @RequestMapping(value={"/startMatching/{subscriptionId}"}, method={RequestMethod.GET})
    public List<String> startMatching(@PathVariable String subscriptionId) {
        Optional s = this.subscriptionRepo.findById((Object)subscriptionId);
        if (s.isPresent()) {
            this.subscriptionEventMatcher.startMatching((Subscription)s.get());
            return Arrays.asList("done");
        }
        return Arrays.asList("subscription not present");
    }

    @ApiOperation(value="Reset the last notification date")
    @RequestMapping(value={"/{id}/date"}, method={RequestMethod.DELETE})
    public void deleteNotificationDate(@PathVariable String id) {
        Subscription s = (Subscription)this.subscriptionRepo.findById((Object)id).get();
        s.setLastNotificationDate(null);
        this.subscriptionRepo.save((Object)s);
    }

    @ApiOperation(value="Reset all the last notification dates")
    @RequestMapping(value={"/resetLastNotificationDates"}, method={RequestMethod.GET})
    public void deleteAllNotificationDates() {
        for (Subscription s : this.subscriptionRepo.findAll()) {
            s.setLastNotificationDate(null);
            this.subscriptionRepo.save((Object)s);
        }
    }
}

