/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.cron;

import eu.dnetlib.lbs.elasticsearch.EventRepository;
import eu.dnetlib.lbs.elasticsearch.NotificationRepository;
import eu.dnetlib.lbs.matchers.SubscriptionEventMatcher;
import eu.dnetlib.lbs.subscriptions.SubscriptionRepository;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledActions {
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private SubscriptionEventMatcher subscriptionEventMatcher;
    private static final Log log = LogFactory.getLog(ScheduledActions.class);

    @Scheduled(cron="${lbs.task.deleteOldEvents.cron}")
    public long deleteExpiredEvents() {
        long n = this.eventRepository.deleteByExpiryDateBefore(new Date().getTime());
        log.info((Object)("Number of deleted expired events: " + n));
        return n;
    }

    @Scheduled(cron="${lbs.task.deleteOldNotifications.cron}")
    public long deleteExpiredNotifications() {
        return 0L;
    }

    @Scheduled(cron="${lbs.task.subscriptionEventsMatcher.cron}")
    public void startSubscriptionEventsMatcher() {
        this.subscriptionRepo.findAll().forEach(arg_0 -> ((SubscriptionEventMatcher)this.subscriptionEventMatcher).startMatching(arg_0));
    }
}

