/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.events.manager;

import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.elasticsearch.EventRepository;
import eu.dnetlib.lbs.elasticsearch.Notification;
import eu.dnetlib.lbs.elasticsearch.NotificationRepository;
import eu.dnetlib.lbs.events.output.DispatcherManager;
import eu.dnetlib.lbs.subscriptions.NotificationFrequency;
import eu.dnetlib.lbs.subscriptions.SubscriptionRepository;
import eu.dnetlib.lbs.utils.LbsQueue;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventManager
implements Runnable {
    private final EventRepository eventRepository;
    private final NotificationRepository notificationRepository;
    private final SubscriptionRepository subscriptionRepo;
    private final DispatcherManager dispatcherManager;
    private final LbsQueue<String, Event> queue;
    private static final Log log = LogFactory.getLog(EventManager.class);

    public EventManager(EventRepository eventRepository, NotificationRepository notificationRepository, SubscriptionRepository subscriptionRepo, DispatcherManager dispatcherManager, LbsQueue<String, Event> queue) {
        this.eventRepository = eventRepository;
        this.notificationRepository = notificationRepository;
        this.subscriptionRepo = subscriptionRepo;
        this.dispatcherManager = dispatcherManager;
        this.queue = queue;
    }

    public boolean add(String s) {
        return this.queue.offer((Object)s);
    }

    @Override
    public void run() {
        log.info((Object)("Event indexer started: " + Thread.currentThread().getName()));
        while (true) {
            List list = this.queue.takeList();
            this.eventRepository.saveAll((Iterable)list);
            list.stream().filter(Event::isInstantMessage).forEach(e -> {
                Iterable iter = this.subscriptionRepo.findByTopic(e.getTopic());
                StreamSupport.stream(iter.spliterator(), false).filter(s -> s.verifyEventConditions(e)).filter(s -> s.getFrequency() == NotificationFrequency.realtime).forEach(s -> {
                    Notification n = new Notification(s, e);
                    this.notificationRepository.save((Object)n);
                    this.dispatcherManager.dispatch(s, new Event[]{e});
                });
            });
        }
    }

    public LbsQueue<String, Event> getQueue() {
        return this.queue;
    }
}

