/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.events.output;

import com.google.common.base.Splitter;
import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.events.output.AbstractNotificationDispatcher;
import eu.dnetlib.lbs.properties.EmailProperties;
import eu.dnetlib.lbs.subscriptions.NotificationMode;
import eu.dnetlib.lbs.subscriptions.Subscription;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class EmailDispatcher
extends AbstractNotificationDispatcher<Message> {
    @Autowired
    private EmailProperties props;
    @Value(value="${lbs.mail.message.template}")
    private Resource emailTemplate;
    private static final int MAX_NUMEBER_OF_EVENTS = 20;
    private static final Log log = LogFactory.getLog(EmailDispatcher.class);

    protected Message prepareAction(Subscription subscription, Event ... events) throws Exception {
        if (subscription == null || StringUtils.isBlank((CharSequence)subscription.getSubscriber())) {
            log.warn((Object)"Invalid subscription");
            throw new IllegalArgumentException("Invalid subscription");
        }
        if (events.length == 0) {
            log.warn((Object)"Event list is empty");
            throw new IllegalArgumentException("Event list is empty");
        }
        String topics = Arrays.stream(events).map(e -> e.getTopic()).distinct().collect(Collectors.joining(", "));
        Session session = Session.getInstance((Properties)this.obtainProperties(), (Authenticator)this.obtainAuthenticator());
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.props.getFrom(), this.props.getFromName()));
        mimeMessage.setSubject("Notification for topic(s): " + topics);
        mimeMessage.setContent((Object)this.generateMailContent(subscription, events), "text/html; charset=utf-8");
        mimeMessage.setSentDate(new Date());
        mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(subscription.getSubscriber()));
        if (StringUtils.isNotBlank((CharSequence)this.props.getCc())) {
            for (String aCC : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)this.props.getCc())) {
                mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(aCC));
            }
        }
        log.info((Object)("Created mail, to: " + subscription.getSubscriber()));
        return mimeMessage;
    }

    private String generateMailContent(Subscription subscription, Event ... events) throws IOException {
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.emailTemplate.getInputStream(), (Charset)StandardCharsets.UTF_8));
        st.setAttribute("sub", (Object)subscription);
        st.setAttribute("total", events.length);
        st.setAttribute("max", 20);
        if (events.length > 20) {
            st.setAttribute("events", (Object)Arrays.copyOfRange(events, 0, 20));
        } else {
            st.setAttribute("events", (Object)events);
        }
        return st.toString();
    }

    protected void performAction(Message message) throws Exception {
        log.info((Object)("Sending mail to " + Arrays.toString(message.getAllRecipients()) + "..."));
        Transport.send((Message)message);
        log.info((Object)"...sent");
    }

    private Properties obtainProperties() {
        Properties p = new Properties();
        p.put("mail.transport.protocol", "smtp");
        p.put("mail.smtp.host", this.props.getSmtpHost());
        p.put("mail.smtp.port", (Object)this.props.getSmtpPort());
        p.put("mail.smtp.auth", Boolean.toString(StringUtils.isNotBlank((CharSequence)this.props.getSmtpUser())));
        return p;
    }

    private Authenticator obtainAuthenticator() {
        if (StringUtils.isBlank((CharSequence)this.props.getSmtpUser())) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NotificationMode getMode() {
        return NotificationMode.EMAIL;
    }

    static /* synthetic */ EmailProperties access$000(EmailDispatcher x0) {
        return x0.props;
    }
}

