/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.openaire;

import com.google.gson.Gson;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.lbs.controllers.AbstractLbsController;
import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.elasticsearch.EventRepository;
import eu.dnetlib.lbs.elasticsearch.Notification;
import eu.dnetlib.lbs.elasticsearch.NotificationRepository;
import eu.dnetlib.lbs.openaire.AdvQueryObject;
import eu.dnetlib.lbs.openaire.BrowseEntry;
import eu.dnetlib.lbs.openaire.ElasticSearchQueryUtils;
import eu.dnetlib.lbs.openaire.EventsPage;
import eu.dnetlib.lbs.openaire.OpenaireSubscription;
import eu.dnetlib.lbs.openaire.Range;
import eu.dnetlib.lbs.openaire.ScrollPage;
import eu.dnetlib.lbs.openaire.SimpleSubscriptionDesc;
import eu.dnetlib.lbs.properties.ElasticSearchProperties;
import eu.dnetlib.lbs.subscriptions.ConditionParams;
import eu.dnetlib.lbs.subscriptions.MapCondition;
import eu.dnetlib.lbs.subscriptions.Subscription;
import eu.dnetlib.lbs.subscriptions.SubscriptionRepository;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/openaireBroker"})
@Api(tags={"OpenAIRE"})
public class OpenaireBrokerController
extends AbstractLbsController {
    private static final int SCROLL_TIMEOUT_IN_MILLIS = 300000;
    private static final int SCROLL_PAGE_SIZE = 100;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private ElasticSearchProperties props;
    private static final Log log = LogFactory.getLog(OpenaireBrokerController.class);

    @ApiOperation(value="Return the datasources having events")
    @RequestMapping(value={"/datasources"}, method={RequestMethod.GET})
    public List<BrowseEntry> findDatasourcesWithEvents() {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withSearchType(SearchType.DEFAULT).withIndices(new String[]{this.props.getEventsIndexName()}).withTypes(new String[]{this.props.getEventsIndexType()}).addAggregation(AggregationBuilders.nested((String)"nested", (String)"map").subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"by_map").field("map.target_datasource_name")).size(1000).minDocCount(1L))).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, SearchResponse::getAggregations);
        Aggregation aggByMap = (Aggregation)((InternalNested)aggregations.asMap().get("nested")).getAggregations().asMap().get("by_map");
        return ((StringTerms)aggByMap).getBuckets().stream().map(b -> new BrowseEntry(b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
    }

    @ApiOperation(value="Return the topics of the events of a datasource")
    @RequestMapping(value={"/topicsForDatasource"}, method={RequestMethod.GET})
    public List<BrowseEntry> findTopicsForDatasource(@RequestParam String ds) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.nestedQuery((String)"map", (QueryBuilder)QueryBuilders.matchQuery((String)"map.target_datasource_name", (Object)ds), (ScoreMode)ScoreMode.None)).withSearchType(SearchType.DEFAULT).withIndices(new String[]{this.props.getEventsIndexName()}).withTypes(new String[]{this.props.getEventsIndexType()}).addAggregation((AbstractAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"topic").field("topic")).size(1000).minDocCount(1L)).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, SearchResponse::getAggregations);
        return ((StringTerms)aggregations.asMap().get("topic")).getBuckets().stream().map(b -> new BrowseEntry(b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
    }

    @ApiOperation(value="Return a page of events of a datasource (by topic)")
    @RequestMapping(value={"/events/{nPage}/{size}"}, method={RequestMethod.GET})
    public EventsPage showEvents(@RequestParam String ds, @RequestParam String topic, @PathVariable int nPage, @PathVariable int size) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"topic", (Object)topic)).must((QueryBuilder)QueryBuilders.nestedQuery((String)"map", (QueryBuilder)QueryBuilders.matchQuery((String)"map.target_datasource_name", (Object)ds), (ScoreMode)ScoreMode.None))).withSearchType(SearchType.DEFAULT).withIndices(new String[]{this.props.getEventsIndexName()}).withTypes(new String[]{this.props.getEventsIndexType()}).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
        Page page = this.eventRepository.search((SearchQuery)searchQuery);
        List list = page.getContent().stream().map(Event::getPayload).map(OpenAireEventPayload::fromJSON).collect(Collectors.toList());
        return new EventsPage(ds, topic, (long)nPage, this.overrideGetTotalPage(page, size), page.getTotalElements(), list);
    }

    @ApiOperation(value="Return a page of events of a datasource (by query)")
    @RequestMapping(value={"/events/{nPage}/{size}"}, method={RequestMethod.POST})
    public EventsPage advancedShowEvents(@PathVariable int nPage, @PathVariable int size, @RequestBody AdvQueryObject qObj) {
        BoolQueryBuilder mapQuery = QueryBuilders.boolQuery();
        ElasticSearchQueryUtils.addMapCondition((BoolQueryBuilder)mapQuery, (String)"map.target_datasource_name", (String)qObj.getDatasource());
        ElasticSearchQueryUtils.addMapCondition((BoolQueryBuilder)mapQuery, (String)"map.target_publication_title", (List)qObj.getTitles());
        ElasticSearchQueryUtils.addMapCondition((BoolQueryBuilder)mapQuery, (String)"map.target_publication_author_list", (List)qObj.getAuthors());
        ElasticSearchQueryUtils.addMapCondition((BoolQueryBuilder)mapQuery, (String)"map.target_publication_subject_list", (List)qObj.getSubjects());
        ElasticSearchQueryUtils.addMapConditionForTrust((BoolQueryBuilder)mapQuery, (String)"map.trust", (Range)qObj.getTrust());
        ElasticSearchQueryUtils.addMapConditionForDates((BoolQueryBuilder)mapQuery, (String)"map.target_dateofacceptance", (List)qObj.getDates());
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"topic", (Object)qObj.getTopic())).must((QueryBuilder)QueryBuilders.nestedQuery((String)"map", (QueryBuilder)mapQuery, (ScoreMode)ScoreMode.None))).withSearchType(SearchType.DEFAULT).withIndices(new String[]{this.props.getEventsIndexName()}).withTypes(new String[]{this.props.getEventsIndexType()}).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
        Page page = this.eventRepository.search((SearchQuery)searchQuery);
        List list = page.getContent().stream().map(Event::getPayload).map(OpenAireEventPayload::fromJSON).collect(Collectors.toList());
        return new EventsPage(qObj.getDatasource(), qObj.getTopic(), (long)nPage, this.overrideGetTotalPage(page, size), page.getTotalElements(), list);
    }

    @ApiOperation(value="Perform a subscription")
    @RequestMapping(value={"/subscribe"}, method={RequestMethod.POST})
    public Subscription registerSubscription(@RequestBody OpenaireSubscription oSub) {
        Subscription sub = oSub.asSubscription();
        this.subscriptionRepo.save((Object)sub);
        return sub;
    }

    @ApiOperation(value="Return the subscriptions of an user (by email)")
    @RequestMapping(value={"/subscriptions"}, method={RequestMethod.GET})
    public Map<String, List<SimpleSubscriptionDesc>> subscriptions(@RequestParam String email) {
        Iterable iter = this.subscriptionRepo.findBySubscriber(email);
        return StreamSupport.stream(iter.spliterator(), false).map(arg_0 -> this.subscriptionDesc(arg_0)).collect(Collectors.groupingBy(SimpleSubscriptionDesc::getDatasource));
    }

    @ApiOperation(value="Return a page of notifications")
    @RequestMapping(value={"/notifications/{subscrId}/{nPage}/{size}"}, method={RequestMethod.GET})
    public EventsPage notifications(@PathVariable String subscrId, @PathVariable int nPage, @PathVariable int size) {
        Optional optSub = this.subscriptionRepo.findById((Object)subscrId);
        if (optSub.isPresent()) {
            Subscription sub = (Subscription)optSub.get();
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchQuery((String)"subscriptionId", (Object)subscrId)).withSearchType(SearchType.DEFAULT).withIndices(new String[]{this.props.getNotificationsIndexName()}).withTypes(new String[]{this.props.getNotificationsIndexType()}).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
            Page page = this.notificationRepository.search((SearchQuery)searchQuery);
            List list = page.getContent().stream().map(Notification::getPayload).map(OpenAireEventPayload::fromJSON).collect(Collectors.toList());
            return new EventsPage(this.extractDatasource(sub), sub.getTopic(), (long)nPage, this.overrideGetTotalPage(page, size), page.getTotalElements(), list);
        }
        log.warn((Object)("Invalid subscription: " + subscrId));
        return new EventsPage("", "", (long)nPage, 0L, 0L, new ArrayList());
    }

    @ApiOperation(value="Returns notifications using scrolls (first page)")
    @RequestMapping(value={"/scroll/notifications/start/{subscrId}"}, method={RequestMethod.GET})
    public ScrollPage prepareScrollNotifications(@PathVariable String subscrId) {
        Optional optSub = this.subscriptionRepo.findById((Object)subscrId);
        if (optSub.isPresent()) {
            QueryBuilder searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchQuery((String)"subscriptionId", (Object)subscrId)).withSearchType(SearchType.DEFAULT).withIndices(new String[]{this.props.getNotificationsIndexName()}).withTypes(new String[]{this.props.getNotificationsIndexType()}).withFields(new String[]{"payload"}).build().getQuery();
            SearchResponse scrollResp = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{this.props.getNotificationsIndexName()}).setScroll(new TimeValue(300000L)).setQuery(searchQuery).setSize(100).get();
            List values = this.calculateEventPayloads(scrollResp);
            return new ScrollPage(scrollResp.getScrollId(), values.isEmpty() || scrollResp.getScrollId() == null, values);
        }
        log.warn((Object)("Invalid subscription: " + subscrId));
        return new ScrollPage();
    }

    @ApiOperation(value="Returns notifications using scrolls (other pages)")
    @RequestMapping(value={"/scroll/notifications/{scrollId}"}, method={RequestMethod.GET})
    public ScrollPage scrollNotifications(@PathVariable String scrollId) {
        SearchResponse scrollResp = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearchScroll(scrollId).setScroll(new TimeValue(300000L)).execute().actionGet();
        List values = this.calculateEventPayloads(scrollResp);
        return new ScrollPage(scrollResp.getScrollId(), values.isEmpty() || scrollResp.getScrollId() == null, values);
    }

    private List<OpenAireEventPayload> calculateEventPayloads(SearchResponse scrollResp) {
        if (scrollResp.getHits().getHits().length > 0) {
            Gson gson = new Gson();
            return Arrays.stream(scrollResp.getHits().getHits()).map(hit -> hit.getSource().get("payload").toString()).map(s -> (OpenAireEventPayload)gson.fromJson(s, OpenAireEventPayload.class)).collect(Collectors.toList());
        }
        return new ArrayList<OpenAireEventPayload>();
    }

    private SimpleSubscriptionDesc subscriptionDesc(Subscription s) {
        return new SimpleSubscriptionDesc(s.getSubscriptionId(), this.extractDatasource(s), s.getTopic(), s.getCreationDate(), s.getLastNotificationDate(), this.notificationRepository.countBySubscriptionId(s.getSubscriptionId()));
    }

    private String extractDatasource(Subscription sub) {
        return sub.getConditionsAsList().stream().filter(c -> c.getField().equals("target_datasource_name")).map(MapCondition::getListParams).filter(l -> !l.isEmpty()).map(l -> ((ConditionParams)l.get(0)).getValue()).findFirst().get();
    }

    private long overrideGetTotalPage(Page<?> page, int size) {
        return (page.getTotalElements() + (long)size - 1L) / (long)size;
    }
}

