/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.topics;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import eu.dnetlib.lbs.elasticsearch.Event;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity(name="topic_types")
@Table(name="topic_types")
public class TopicType {
    @Id
    @Column(name="id")
    private String id;
    @Column(name="name", nullable=false, unique=true)
    private String name;
    @Column(name="expression", length=4096, unique=true, nullable=false)
    private String expression;
    @Column(name="regex", length=4096, unique=true, nullable=false)
    private String regex;
    @Column(name="producerId", length=4096)
    private String producerId;
    @Column(name="mapKeys", length=4096)
    private String mapKeys;

    public TopicType() {
    }

    public TopicType(String id, String name, String expression, String producerId, String mapKeys) {
        this.id = id;
        this.name = name;
        this.expression = expression;
        this.producerId = producerId;
        this.mapKeys = mapKeys;
        this.updateRegex();
    }

    public TopicType(String id, String name, String expression, String producerId, Set<String> mapKeys) {
        this(id, name, expression, producerId, Joiner.on((String)",").join(mapKeys));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public void setProducerId(String producerId) {
        this.producerId = producerId;
    }

    public String getMapKeys() {
        return this.mapKeys;
    }

    public void setMapKeys(Set<String> mapKeys) {
        this.mapKeys = Joiner.on((String)",").join(mapKeys);
    }

    public Set<String> getMapKeysAsSet() {
        return Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.mapKeys));
    }

    public void setMapKeys(String mapKeys) {
        this.mapKeys = mapKeys;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.updateRegex();
    }

    private void updateRegex() {
        this.regex = "^" + this.expression.replaceAll("<[a-zA-Z0-9._-]+>", "[a-zA-Z0-9._-]+").replaceAll("\\/", "\\\\/").trim() + "$";
    }

    public String getRegex() {
        return this.regex;
    }

    public Predicate<Event> asValidator() {
        Predicate<String> p = Pattern.compile(this.getRegex()).asPredicate();
        Set keys = this.getMapKeysAsSet();
        return e -> e != null && StringUtils.isNotBlank((CharSequence)e.getTopic()) && p.test(e.getTopic()) && (StringUtils.isBlank((CharSequence)this.producerId) || this.producerId.equals(e.getProducerId())) && e.getMap().keySet().containsAll(keys);
    }
}

