/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.utils;

import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.topics.TopicType;
import eu.dnetlib.lbs.topics.TopicTypeRepository;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventVerifier
implements Predicate<Event> {
    private final TopicTypeRepository topicTypeRepo;
    private final long MAX_DELAY = 5000L;
    private Instant last = Instant.EPOCH;
    private List<Predicate<Event>> validators = new ArrayList();
    private static final Log log = LogFactory.getLog(EventVerifier.class);

    public EventVerifier(TopicTypeRepository topicTypeRepo) {
        this.topicTypeRepo = topicTypeRepo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(Event event) {
        if (event == null || StringUtils.isBlank((CharSequence)event.getProducerId())) {
            return false;
        }
        Instant now = Instant.now();
        long l = Duration.between(this.last, now).toMillis();
        this.getClass();
        if (l > 5000L) {
            log.info((Object)"Updating the list of topic regex");
            Iterable iter = this.topicTypeRepo.findAll();
            this.validators = StreamSupport.stream(iter.spliterator(), false).map(TopicType::asValidator).collect(Collectors.toList());
        }
        try {
            boolean iter = this.validators.stream().anyMatch(p -> p.test(event));
            return iter;
        }
        catch (Throwable e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.last = now;
        }
    }
}

