package eu.dnetlib.lbs.controllers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import eu.dnetlib.lbs.LiteratureBrokerServiceConfiguration;
import eu.dnetlib.lbs.elasticsearch.Notification;
import eu.dnetlib.lbs.elasticsearch.NotificationRepository;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping("/api/notifications")
@Api(tags = LiteratureBrokerServiceConfiguration.TAG_NOTIFICATIONS)
public class NotificationsController extends AbstractLbsController {

	@Autowired
	private NotificationRepository notificationRepository;

	@ApiOperation("Return a notification by ID")
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	public Notification getNotification(@PathVariable final String id) {
		return this.notificationRepository.findById(id).get();
	}

	@ApiOperation("Delete a notification by ID")
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	public void deleteNotification(@PathVariable final String id) {
		this.notificationRepository.deleteById(id);
	}

	@ApiOperation("Save a notification by ID")
	@RequestMapping(value = "/{id}", method = RequestMethod.POST)
	public Notification saveNotification(@RequestBody final Notification notification) {
		return this.notificationRepository.save(notification);
	}

	@ApiOperation("Delete all notifications")
	@RequestMapping(value = "", method = RequestMethod.DELETE)
	public void deleteAllNotifications() {
		this.notificationRepository.deleteAll();
	}

}
