package eu.dnetlib.lbs.elasticsearch;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;

public interface EventRepository extends ElasticsearchRepository<Event, String> {
	// TODO: use the @Query annotation if necessary
	// See: http://docs.spring.io/spring-data/elasticsearch/docs/current/reference/html/

	Iterable<Event> findByTopic(String topic);

	Page<Event> findByTopic(String topic, Pageable pageable);

	long deleteByExpiryDateBefore(long l);

}
