package eu.dnetlib.lbs.properties;

import javax.validation.constraints.NotNull;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "lbs.rabbit")
public class RabbitMQProperties {

	@NotNull
	private boolean enabled;
	@NotNull
	private String host;
	@NotNull
	private int port;
	@NotNull
	private String username;
	@NotNull
	private String password;
	@NotNull
	private String queue;
	@NotNull
	private int numberOfConsumers;
	@NotNull
	private String homepage;

	public boolean isEnabled() {
		return this.enabled;
	}

	public void setEnabled(final boolean enabled) {
		this.enabled = enabled;
	}

	public String getHost() {
		return this.host;
	}

	public void setHost(final String host) {
		this.host = host;
	}

	public int getPort() {
		return this.port;
	}

	public void setPort(final int port) {
		this.port = port;
	}

	public String getUsername() {
		return this.username;
	}

	public void setUsername(final String username) {
		this.username = username;
	}

	public String getPassword() {
		return this.password;
	}

	public void setPassword(final String password) {
		this.password = password;
	}

	public String getQueue() {
		return this.queue;
	}

	public void setQueue(final String queue) {
		this.queue = queue;
	}

	public int getNumberOfConsumers() {
		return this.numberOfConsumers;
	}

	public void setNumberOfConsumers(final int numberOfConsumers) {
		this.numberOfConsumers = numberOfConsumers;
	}

	public String getHomepage() {
		return this.homepage;
	}

	public void setHomepage(final String homepage) {
		this.homepage = homepage;
	}

}
