/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.events.input;

import eu.dnetlib.lbs.events.input.MapValue;
import eu.dnetlib.lbs.events.input.MapValueType;
import eu.dnetlib.lbs.utils.DateParser;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapValue {
    private MapValueType type = MapValueType.STRING;
    private Object value = "";
    private static final Log log = LogFactory.getLog(MapValue.class);

    public MapValue() {
    }

    public MapValue(MapValueType type, Object value) {
        this.type = type;
        this.value = value;
    }

    public MapValueType getType() {
        return this.type;
    }

    public void setType(MapValueType type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object asObject() {
        if (this.value == null) {
            log.warn((Object)"Object is NULL");
            return null;
        }
        try {
            switch (1.$SwitchMap$eu$dnetlib$lbs$events$input$MapValueType[this.type.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return this.asSimpleObject(this.getType(), this.getValue().toString());
                }
                case 6: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.STRING, o.toString())).collect(Collectors.toList());
                }
                case 7: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.INTEGER, o.toString())).collect(Collectors.toList());
                }
                case 8: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.FLOAT, o.toString())).collect(Collectors.toList());
                }
                case 9: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.BOOLEAN, o.toString())).collect(Collectors.toList());
                }
                case 10: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.DATE, o.toString())).collect(Collectors.toList());
                }
            }
            log.warn((Object)("Invalid type: " + this.type));
            return null;
        }
        catch (Exception e) {
            log.warn((Object)("Error parsing value: " + this));
            return null;
        }
    }

    private Object asSimpleObject(MapValueType type, String s) {
        try {
            switch (1.$SwitchMap$eu$dnetlib$lbs$events$input$MapValueType[type.ordinal()]) {
                case 1: {
                    return s.toString();
                }
                case 2: {
                    return s.contains(".") ? NumberUtils.toLong((String)StringUtils.substringBefore((String)s, (String)"."), (long)0L) : NumberUtils.toLong((String)s, (long)0L);
                }
                case 3: {
                    return NumberUtils.toDouble((String)s, (double)0.0);
                }
                case 4: {
                    return BooleanUtils.toBoolean((String)s);
                }
                case 5: {
                    return DateParser.parse((String)s);
                }
            }
            log.warn((Object)("Unmamaged type: " + type));
            return null;
        }
        catch (Exception e) {
            log.warn((Object)("Error parsing value: " + s + " - type: " + type));
            return null;
        }
    }

    public String toString() {
        return String.format("[ type; %s, value: %s ]", this.getType(), this.getValue());
    }
}

