/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.events.input;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.events.input.RabbitMQConsumer;
import eu.dnetlib.lbs.utils.LbsQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RabbitMQConsumer
implements Runnable {
    private final String queue;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final LbsQueue<String, Event> localQueue;
    private static final Log log = LogFactory.getLog(RabbitMQConsumer.class);

    public RabbitMQConsumer(String queue, String host, int port, String username, String password, LbsQueue<String, Event> localQueue) {
        this.queue = queue;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.localQueue = localQueue;
    }

    @Override
    public void run() {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(this.host);
        factory.setPort(this.port);
        factory.setUsername(this.username);
        factory.setPassword(this.password);
        factory.setAutomaticRecoveryEnabled(true);
        log.info((Object)("Starting rabbitMQ consumer: " + Thread.currentThread().getName()));
        try {
            Connection connection = factory.newConnection();
            Channel channel = connection.createChannel();
            1 consumer = new /* Unavailable Anonymous Inner Class!! */;
            channel.queueDeclare(this.queue, true, false, false, null);
            channel.basicConsume(this.queue, false, (Consumer)consumer);
        }
        catch (Exception e) {
            log.error((Object)"Error creating consumer", (Throwable)e);
        }
    }

    public String getQueue() {
        return this.queue;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public LbsQueue<String, Event> getLocalQueue() {
        return this.localQueue;
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

