/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.controllers;

import eu.dnetlib.lbs.controllers.AbstractLbsController;
import eu.dnetlib.lbs.elasticsearch.Notification;
import eu.dnetlib.lbs.elasticsearch.NotificationRepository;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notifications"})
@Api(tags={"Notifications"})
public class NotificationsController
extends AbstractLbsController {
    @Autowired
    private NotificationRepository notificationRepository;

    @ApiOperation(value="Return a notification by ID")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public Notification getNotification(@PathVariable String id) {
        return (Notification)this.notificationRepository.findById((Object)id).get();
    }

    @ApiOperation(value="Delete a notification by ID")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void deleteNotification(@PathVariable String id) {
        this.notificationRepository.deleteById((Object)id);
    }

    @ApiOperation(value="Save a notification by ID")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public Notification saveNotification(@RequestBody Notification notification) {
        return (Notification)this.notificationRepository.save((Object)notification);
    }

    @ApiOperation(value="Delete all notifications")
    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    public void deleteAllNotifications() {
        this.notificationRepository.deleteAll();
    }
}

