/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.elasticsearch;

import eu.dnetlib.lbs.elasticsearch.EventStatsManager;
import eu.dnetlib.lbs.properties.ElasticSearchProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Component;

@Component
public class EventStatsManager {
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private ElasticSearchProperties elasticSearchProperties;
    private static final Log log = LogFactory.getLog(EventStatsManager.class);

    public List<BrowseEntry> browseTopics() {
        String term = "topic";
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withSearchType(SearchType.DEFAULT).withIndices(new String[]{this.elasticSearchProperties.getEventsIndexName()}).withTypes(new String[]{this.elasticSearchProperties.getEventsIndexType()}).addAggregation((AbstractAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"topic").field("topic")).size(1000).minDocCount(1L)).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, SearchResponse::getAggregations);
        return ((StringTerms)aggregations.asMap().get("topic")).getBuckets().stream().map(b -> new BrowseEntry(this, b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
    }
}

